/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.access;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.agg.access.AggregationAccessor;
import com.espertech.esper.epl.agg.access.AggregationState;
import com.espertech.esper.epl.agg.access.AggregationStateLinear;
import com.espertech.esper.epl.expression.ExprEvaluator;
import java.util.Collection;
import java.util.Collections;

public class AggregationAccessorFirstLastIndex
implements AggregationAccessor {
    private final int streamNum;
    private final ExprEvaluator childNode;
    private final EventBean[] eventsPerStream;
    private final ExprEvaluator indexNode;
    private final int constant;
    private final boolean isFirst;

    public AggregationAccessorFirstLastIndex(int streamNum, ExprEvaluator childNode, ExprEvaluator indexNode, int constant, boolean isFirst) {
        this.streamNum = streamNum;
        this.childNode = childNode;
        this.indexNode = indexNode;
        this.eventsPerStream = new EventBean[streamNum + 1];
        this.constant = constant;
        this.isFirst = isFirst;
    }

    @Override
    public Object getValue(AggregationState state) {
        EventBean bean = this.getBean(state);
        if (bean == null) {
            return null;
        }
        this.eventsPerStream[this.streamNum] = bean;
        return this.childNode.evaluate(this.eventsPerStream, true, null);
    }

    @Override
    public Collection<EventBean> getEnumerableEvents(AggregationState state) {
        EventBean bean = this.getBean(state);
        if (bean == null) {
            return null;
        }
        return Collections.singletonList(bean);
    }

    @Override
    public EventBean getEnumerableEvent(AggregationState state) {
        return this.getBean(state);
    }

    private EventBean getBean(AggregationState state) {
        int index = this.constant;
        if (index == -1) {
            Object result = this.indexNode.evaluate(null, true, null);
            if (result == null || !(result instanceof Integer)) {
                return null;
            }
            index = (Integer)result;
        }
        EventBean bean = this.isFirst ? ((AggregationStateLinear)((Object)state)).getFirstNthValue(index) : ((AggregationStateLinear)((Object)state)).getLastNthValue(index);
        return bean;
    }
}

