/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.access;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.agg.access.AggregationStateLinear;
import com.espertech.esper.epl.agg.access.AggregationStateWithSize;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class AggregationStateImpl
implements AggregationStateWithSize,
AggregationStateLinear {
    protected int streamId;
    protected ArrayList<EventBean> events = new ArrayList();

    public AggregationStateImpl(int streamId) {
        this.streamId = streamId;
    }

    @Override
    public void clear() {
        this.events.clear();
    }

    @Override
    public void applyLeave(EventBean[] eventsPerStream, ExprEvaluatorContext exprEvaluatorContext) {
        EventBean theEvent = eventsPerStream[this.streamId];
        if (theEvent == null) {
            return;
        }
        this.events.remove(theEvent);
    }

    @Override
    public void applyEnter(EventBean[] eventsPerStream, ExprEvaluatorContext exprEvaluatorContext) {
        EventBean theEvent = eventsPerStream[this.streamId];
        if (theEvent == null) {
            return;
        }
        this.events.add(theEvent);
    }

    @Override
    public EventBean getFirstNthValue(int index) {
        if (index < 0) {
            return null;
        }
        if (index >= this.events.size()) {
            return null;
        }
        return this.events.get(index);
    }

    @Override
    public EventBean getLastNthValue(int index) {
        if (index < 0) {
            return null;
        }
        if (index >= this.events.size()) {
            return null;
        }
        return this.events.get(this.events.size() - index - 1);
    }

    @Override
    public EventBean getFirstValue() {
        if (this.events.isEmpty()) {
            return null;
        }
        return this.events.get(0);
    }

    @Override
    public EventBean getLastValue() {
        if (this.events.isEmpty()) {
            return null;
        }
        return this.events.get(this.events.size() - 1);
    }

    @Override
    public Iterator<EventBean> iterator() {
        return this.events.iterator();
    }

    @Override
    public Collection<EventBean> collectionReadOnly() {
        return this.events;
    }

    @Override
    public int size() {
        return this.events.size();
    }
}

