/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.access;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.epl.agg.access.AggregationStateSorted;
import com.espertech.esper.epl.agg.access.AggregationStateSortedIterator;
import com.espertech.esper.epl.agg.access.AggregationStateSortedSpec;
import com.espertech.esper.epl.agg.access.AggregationStateSortedWrappingCollection;
import com.espertech.esper.epl.agg.access.AggregationStateWithSize;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class AggregationStateSortedImpl
implements AggregationStateWithSize,
AggregationStateSorted {
    protected final AggregationStateSortedSpec spec;
    protected final TreeMap<Object, Object> sorted;
    protected int size;

    public AggregationStateSortedImpl(AggregationStateSortedSpec spec) {
        this.spec = spec;
        this.sorted = new TreeMap(spec.getComparator());
    }

    @Override
    public void clear() {
        this.sorted.clear();
        this.size = 0;
    }

    @Override
    public void applyEnter(EventBean[] eventsPerStream, ExprEvaluatorContext exprEvaluatorContext) {
        EventBean theEvent = eventsPerStream[this.spec.getStreamId()];
        if (theEvent == null) {
            return;
        }
        if (this.referenceEvent(theEvent)) {
            Object comparable = AggregationStateSortedImpl.getComparable(this.spec.getCriteria(), eventsPerStream, true, exprEvaluatorContext);
            Object existing = this.sorted.get(comparable);
            if (existing == null) {
                this.sorted.put(comparable, theEvent);
            } else if (existing instanceof EventBean) {
                ArrayDeque<Object> coll = new ArrayDeque<Object>(2);
                coll.add(existing);
                coll.add(theEvent);
                this.sorted.put(comparable, coll);
            } else {
                ArrayDeque q = (ArrayDeque)existing;
                q.add(theEvent);
            }
            ++this.size;
        }
    }

    protected boolean referenceEvent(EventBean theEvent) {
        return true;
    }

    protected boolean dereferenceEvent(EventBean theEvent) {
        return true;
    }

    @Override
    public void applyLeave(EventBean[] eventsPerStream, ExprEvaluatorContext exprEvaluatorContext) {
        Object comparable;
        Object existing;
        EventBean theEvent = eventsPerStream[this.spec.getStreamId()];
        if (theEvent == null) {
            return;
        }
        if (this.dereferenceEvent(theEvent) && (existing = this.sorted.get(comparable = AggregationStateSortedImpl.getComparable(this.spec.getCriteria(), eventsPerStream, false, exprEvaluatorContext))) != null) {
            if (existing.equals(theEvent)) {
                this.sorted.remove(comparable);
                --this.size;
            } else if (existing instanceof ArrayDeque) {
                ArrayDeque q = (ArrayDeque)existing;
                q.remove(theEvent);
                if (q.isEmpty()) {
                    this.sorted.remove(comparable);
                }
                --this.size;
            }
        }
    }

    @Override
    public EventBean getFirstValue() {
        if (this.sorted.isEmpty()) {
            return null;
        }
        Map.Entry<Object, Object> max = this.sorted.firstEntry();
        return this.checkedPayload(max.getValue());
    }

    @Override
    public EventBean getLastValue() {
        if (this.sorted.isEmpty()) {
            return null;
        }
        Map.Entry<Object, Object> min = this.sorted.lastEntry();
        return this.checkedPayload(min.getValue());
    }

    @Override
    public Iterator<EventBean> iterator() {
        return new AggregationStateSortedIterator(this.sorted, false);
    }

    @Override
    public Iterator<EventBean> getReverseIterator() {
        return new AggregationStateSortedIterator(this.sorted, true);
    }

    @Override
    public Collection<EventBean> collectionReadOnly() {
        return new AggregationStateSortedWrappingCollection(this.sorted, this.size);
    }

    @Override
    public int size() {
        return this.size;
    }

    protected static Object getComparable(ExprEvaluator[] criteria, EventBean[] eventsPerStream, boolean istream, ExprEvaluatorContext exprEvaluatorContext) {
        if (criteria.length == 1) {
            return criteria[0].evaluate(eventsPerStream, istream, exprEvaluatorContext);
        }
        Object[] result = new Object[criteria.length];
        int count = 0;
        for (ExprEvaluator expr : criteria) {
            result[count++] = expr.evaluate(eventsPerStream, true, exprEvaluatorContext);
        }
        return new MultiKeyUntyped(result);
    }

    private EventBean checkedPayload(Object value) {
        if (value instanceof EventBean) {
            return (EventBean)value;
        }
        ArrayDeque q = (ArrayDeque)value;
        return (EventBean)q.getFirst();
    }
}

