/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.aggregator;

import com.espertech.esper.collection.RefCountedSet;
import com.espertech.esper.epl.agg.aggregator.AggregationMethod;

public class AggregatorDistinctValueFilter
implements AggregationMethod {
    protected final AggregationMethod inner;
    protected final RefCountedSet<Object> valueSet;

    public AggregatorDistinctValueFilter(AggregationMethod inner) {
        this.inner = inner;
        this.valueSet = new RefCountedSet();
    }

    @Override
    public void clear() {
        this.valueSet.clear();
        this.inner.clear();
    }

    @Override
    public void enter(Object value) {
        Object[] values = (Object[])value;
        if (!this.checkPass(values)) {
            return;
        }
        if (this.valueSet.add(values[0])) {
            this.inner.enter(value);
        }
    }

    @Override
    public void leave(Object value) {
        Object[] values = (Object[])value;
        if (!this.checkPass(values)) {
            return;
        }
        if (this.valueSet.remove(values[0])) {
            this.inner.leave(value);
        }
    }

    @Override
    public Object getValue() {
        return this.inner.getValue();
    }

    @Override
    public Class getValueType() {
        return this.inner.getValueType();
    }

    private boolean checkPass(Object[] object) {
        Boolean first = (Boolean)object[1];
        if (first != null) {
            return first;
        }
        return false;
    }
}

