/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.aggregator;

import com.espertech.esper.epl.agg.aggregator.AggregationMethod;
import com.espertech.esper.schedule.TimeProvider;
import java.util.ArrayDeque;

public class AggregatorRateEver
implements AggregationMethod {
    protected final long interval;
    protected final ArrayDeque<Long> points;
    protected boolean hasLeave = false;
    protected final TimeProvider timeProvider;

    public AggregatorRateEver(long interval, TimeProvider timeProvider) {
        this.interval = interval;
        this.timeProvider = timeProvider;
        this.points = new ArrayDeque();
    }

    @Override
    public void clear() {
        this.points.clear();
    }

    @Override
    public void enter(Object object) {
        long timestamp = this.timeProvider.getTime();
        this.points.add(timestamp);
        this.removeFromHead(timestamp);
    }

    @Override
    public void leave(Object object) {
    }

    @Override
    public Object getValue() {
        if (!this.points.isEmpty()) {
            long newest = this.points.getLast();
            this.removeFromHead(newest);
        }
        if (!this.hasLeave) {
            return null;
        }
        if (this.points.isEmpty()) {
            return 0.0;
        }
        return (double)this.points.size() * 1000.0 / (double)this.interval;
    }

    private void removeFromHead(long timestamp) {
        block2: {
            if (this.points.size() <= 1) break block2;
            do {
                long first;
                long delta;
                if ((delta = timestamp - (first = this.points.getFirst().longValue())) < this.interval) {
                    if (delta != this.interval) break;
                    this.hasLeave = true;
                    break;
                }
                this.points.remove();
                this.hasLeave = true;
            } while (!this.points.isEmpty());
        }
    }

    @Override
    public Class getValueType() {
        return Double.class;
    }
}

