/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.service;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.agg.access.AggregationAccessorSlotPair;
import com.espertech.esper.epl.agg.access.AggregationState;
import com.espertech.esper.epl.agg.service.AggregationResultFuture;
import com.espertech.esper.epl.agg.service.AggregationRowRemovedCallback;
import com.espertech.esper.epl.agg.service.AggregationService;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import java.util.Collection;

public class AggSvcGroupAllAccessOnlyImpl
implements AggregationService,
AggregationResultFuture {
    private final AggregationAccessorSlotPair[] accessors;
    protected final AggregationState[] states;

    public AggSvcGroupAllAccessOnlyImpl(AggregationAccessorSlotPair[] accessors, AggregationState[] states) {
        this.accessors = accessors;
        this.states = states;
    }

    @Override
    public void applyEnter(EventBean[] eventsPerStream, Object groupKey, ExprEvaluatorContext exprEvaluatorContext) {
        for (AggregationState state : this.states) {
            state.applyEnter(eventsPerStream, exprEvaluatorContext);
        }
    }

    @Override
    public void applyLeave(EventBean[] eventsPerStream, Object groupKey, ExprEvaluatorContext exprEvaluatorContext) {
        for (AggregationState state : this.states) {
            state.applyLeave(eventsPerStream, exprEvaluatorContext);
        }
    }

    @Override
    public void setCurrentAccess(Object groupKey, int agentInstanceId) {
    }

    @Override
    public Object getValue(int column, int agentInstanceId) {
        AggregationAccessorSlotPair pair = this.accessors[column];
        return pair.getAccessor().getValue(this.states[pair.getSlot()]);
    }

    @Override
    public EventBean getEventBean(int column, ExprEvaluatorContext context) {
        AggregationAccessorSlotPair pair = this.accessors[column];
        return pair.getAccessor().getEnumerableEvent(this.states[pair.getSlot()]);
    }

    @Override
    public Collection<EventBean> getCollection(int column, ExprEvaluatorContext context) {
        AggregationAccessorSlotPair pair = this.accessors[column];
        return pair.getAccessor().getEnumerableEvents(this.states[pair.getSlot()]);
    }

    @Override
    public void clearResults(ExprEvaluatorContext exprEvaluatorContext) {
        for (AggregationState state : this.states) {
            state.clear();
        }
    }

    @Override
    public void setRemovedCallback(AggregationRowRemovedCallback callback) {
    }
}

