/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.service;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.agg.access.AggregationAccessorSlotPair;
import com.espertech.esper.epl.agg.access.AggregationState;
import com.espertech.esper.epl.agg.aggregator.AggregationMethod;
import com.espertech.esper.epl.agg.service.AggregationRowRemovedCallback;
import com.espertech.esper.epl.agg.service.AggregationServiceBaseUngrouped;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import java.util.Collection;

public class AggSvcGroupAllMixedAccessImpl
extends AggregationServiceBaseUngrouped {
    private final AggregationAccessorSlotPair[] accessors;
    protected AggregationState[] states;

    public AggSvcGroupAllMixedAccessImpl(ExprEvaluator[] evaluators, AggregationMethod[] aggregators, AggregationAccessorSlotPair[] accessors, AggregationState[] states) {
        super(evaluators, aggregators);
        this.accessors = accessors;
        this.states = states;
    }

    @Override
    public void applyEnter(EventBean[] eventsPerStream, Object optionalGroupKeyPerRow, ExprEvaluatorContext exprEvaluatorContext) {
        for (int j = 0; j < this.evaluators.length; ++j) {
            Object columnResult = this.evaluators[j].evaluate(eventsPerStream, true, exprEvaluatorContext);
            this.aggregators[j].enter(columnResult);
        }
        for (AggregationState state : this.states) {
            state.applyEnter(eventsPerStream, exprEvaluatorContext);
        }
    }

    @Override
    public void applyLeave(EventBean[] eventsPerStream, Object optionalGroupKeyPerRow, ExprEvaluatorContext exprEvaluatorContext) {
        for (int j = 0; j < this.evaluators.length; ++j) {
            Object columnResult = this.evaluators[j].evaluate(eventsPerStream, false, exprEvaluatorContext);
            this.aggregators[j].leave(columnResult);
        }
        for (AggregationState state : this.states) {
            state.applyLeave(eventsPerStream, exprEvaluatorContext);
        }
    }

    @Override
    public void setCurrentAccess(Object groupKey, int agentInstanceId) {
    }

    @Override
    public Object getValue(int column, int agentInstanceId) {
        if (column < this.aggregators.length) {
            return this.aggregators[column].getValue();
        }
        AggregationAccessorSlotPair pair = this.accessors[column - this.aggregators.length];
        return pair.getAccessor().getValue(this.states[pair.getSlot()]);
    }

    @Override
    public Collection<EventBean> getCollection(int column, ExprEvaluatorContext context) {
        if (column < this.aggregators.length) {
            return null;
        }
        AggregationAccessorSlotPair pair = this.accessors[column - this.aggregators.length];
        return pair.getAccessor().getEnumerableEvents(this.states[pair.getSlot()]);
    }

    @Override
    public EventBean getEventBean(int column, ExprEvaluatorContext context) {
        if (column < this.aggregators.length) {
            return null;
        }
        AggregationAccessorSlotPair pair = this.accessors[column - this.aggregators.length];
        return pair.getAccessor().getEnumerableEvent(this.states[pair.getSlot()]);
    }

    @Override
    public void clearResults(ExprEvaluatorContext exprEvaluatorContext) {
        for (AggregationState state : this.states) {
            state.clear();
        }
        for (AggregationMethod aggregator : this.aggregators) {
            aggregator.clear();
        }
    }

    @Override
    public void setRemovedCallback(AggregationRowRemovedCallback callback) {
    }
}

