/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.service;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.agg.access.AggregationAccessorSlotPair;
import com.espertech.esper.epl.agg.access.AggregationState;
import com.espertech.esper.epl.agg.service.AggregationResultFuture;
import com.espertech.esper.epl.agg.service.AggregationRowRemovedCallback;
import com.espertech.esper.epl.agg.service.AggregationService;
import com.espertech.esper.epl.agg.service.AggregationStateFactory;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class AggSvcGroupByAccessOnlyImpl
implements AggregationService,
AggregationResultFuture {
    private final MethodResolutionService methodResolutionService;
    private final Map<Object, AggregationState[]> accessMap;
    private final AggregationAccessorSlotPair[] accessors;
    private final AggregationStateFactory[] accessAggSpecs;
    private final boolean isJoin;
    private AggregationState[] currentAcceses;

    public AggSvcGroupByAccessOnlyImpl(MethodResolutionService methodResolutionService, AggregationAccessorSlotPair[] accessors, AggregationStateFactory[] accessAggSpecs, boolean isJoin) {
        this.methodResolutionService = methodResolutionService;
        this.accessMap = new HashMap<Object, AggregationState[]>();
        this.accessors = accessors;
        this.accessAggSpecs = accessAggSpecs;
        this.isJoin = isJoin;
    }

    @Override
    public void applyEnter(EventBean[] eventsPerStream, Object groupKey, ExprEvaluatorContext exprEvaluatorContext) {
        AggregationState[] row;
        for (AggregationState state : row = this.getAssertRow(exprEvaluatorContext.getAgentInstanceId(), groupKey)) {
            state.applyEnter(eventsPerStream, exprEvaluatorContext);
        }
    }

    @Override
    public void applyLeave(EventBean[] eventsPerStream, Object groupKey, ExprEvaluatorContext exprEvaluatorContext) {
        AggregationState[] row;
        for (AggregationState state : row = this.getAssertRow(exprEvaluatorContext.getAgentInstanceId(), groupKey)) {
            state.applyLeave(eventsPerStream, exprEvaluatorContext);
        }
    }

    @Override
    public void setCurrentAccess(Object groupKey, int agentInstanceId) {
        this.currentAcceses = this.getAssertRow(agentInstanceId, groupKey);
    }

    @Override
    public Object getValue(int column, int agentInstanceId) {
        AggregationAccessorSlotPair pair = this.accessors[column];
        return pair.getAccessor().getValue(this.currentAcceses[pair.getSlot()]);
    }

    @Override
    public Collection<EventBean> getCollection(int column, ExprEvaluatorContext context) {
        AggregationAccessorSlotPair pair = this.accessors[column];
        return pair.getAccessor().getEnumerableEvents(this.currentAcceses[pair.getSlot()]);
    }

    @Override
    public EventBean getEventBean(int column, ExprEvaluatorContext context) {
        AggregationAccessorSlotPair pair = this.accessors[column];
        return pair.getAccessor().getEnumerableEvent(this.currentAcceses[pair.getSlot()]);
    }

    @Override
    public void clearResults(ExprEvaluatorContext exprEvaluatorContext) {
        this.accessMap.clear();
    }

    private AggregationState[] getAssertRow(int agentInstanceId, Object groupKey) {
        AggregationState[] row = this.accessMap.get(groupKey);
        if (row != null) {
            return row;
        }
        row = this.methodResolutionService.newAccesses(agentInstanceId, this.isJoin, this.accessAggSpecs, groupKey);
        this.accessMap.put(groupKey, row);
        return row;
    }

    @Override
    public void setRemovedCallback(AggregationRowRemovedCallback callback) {
    }
}

