/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.service;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.agg.aggregator.AggregationMethod;
import com.espertech.esper.epl.agg.service.AggregationMethodFactory;
import com.espertech.esper.epl.agg.service.AggregationRowRemovedCallback;
import com.espertech.esper.epl.agg.service.AggregationServiceBaseGrouped;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import java.util.Collection;

public class AggSvcGroupByExperimental
extends AggregationServiceBaseGrouped {
    private AggregationMethod[] currentAggregatorRow;
    private MethodResolutionService methodResolutionService;
    private Object lastrow;

    public AggSvcGroupByExperimental(ExprEvaluator[] evaluators, AggregationMethodFactory[] prototypes, MethodResolutionService methodResolutionService) {
        super(evaluators, prototypes);
        this.methodResolutionService = methodResolutionService;
    }

    @Override
    public void clearResults(ExprEvaluatorContext exprEvaluatorContext) {
    }

    @Override
    public void applyEnter(EventBean[] eventsPerStream, Object groupByKey, ExprEvaluatorContext exprEvaluatorContext) {
        if (this.lastrow == null || !this.lastrow.equals(groupByKey)) {
            AggregationMethod[] groupAggregators = this.methodResolutionService.newAggregators(this.aggregators, exprEvaluatorContext.getAgentInstanceId(), groupByKey);
            this.currentAggregatorRow = groupAggregators;
        }
        this.lastrow = groupByKey;
        for (int j = 0; j < this.evaluators.length; ++j) {
            Object columnResult = this.evaluators[j].evaluate(eventsPerStream, true, exprEvaluatorContext);
            this.currentAggregatorRow[j].enter(columnResult);
        }
    }

    @Override
    public void applyLeave(EventBean[] eventsPerStream, Object groupByKey, ExprEvaluatorContext exprEvaluatorContext) {
        if (this.lastrow == null || !this.lastrow.equals(groupByKey)) {
            AggregationMethod[] groupAggregators = this.methodResolutionService.newAggregators(this.aggregators, exprEvaluatorContext.getAgentInstanceId(), groupByKey);
            this.currentAggregatorRow = groupAggregators;
        }
        this.lastrow = groupByKey;
        for (int j = 0; j < this.evaluators.length; ++j) {
            Object columnResult = this.evaluators[j].evaluate(eventsPerStream, false, exprEvaluatorContext);
            this.currentAggregatorRow[j].leave(columnResult);
        }
    }

    @Override
    public void setCurrentAccess(Object groupByKey, int agentInstanceId) {
        if (this.lastrow == null || !this.lastrow.equals(groupByKey)) {
            AggregationMethod[] groupAggregators = this.methodResolutionService.newAggregators(this.aggregators, agentInstanceId, groupByKey);
            this.currentAggregatorRow = groupAggregators;
        }
        this.lastrow = groupByKey;
    }

    @Override
    public Object getValue(int column, int agentInstanceId) {
        return this.currentAggregatorRow[column].getValue();
    }

    @Override
    public Collection<EventBean> getCollection(int column, ExprEvaluatorContext context) {
        return null;
    }

    @Override
    public EventBean getEventBean(int column, ExprEvaluatorContext context) {
        return null;
    }

    @Override
    public void setRemovedCallback(AggregationRowRemovedCallback callback) {
    }
}

