/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.service;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.agg.access.AggregationAccessorSlotPair;
import com.espertech.esper.epl.agg.access.AggregationState;
import com.espertech.esper.epl.agg.aggregator.AggregationMethod;
import com.espertech.esper.epl.agg.service.AggregationMethodFactory;
import com.espertech.esper.epl.agg.service.AggregationRowPair;
import com.espertech.esper.epl.agg.service.AggregationRowRemovedCallback;
import com.espertech.esper.epl.agg.service.AggregationServiceBaseGrouped;
import com.espertech.esper.epl.agg.service.AggregationStateFactory;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class AggSvcGroupByMixedAccessImpl
extends AggregationServiceBaseGrouped {
    private final AggregationAccessorSlotPair[] accessorsFactory;
    protected final AggregationStateFactory[] accessAggregations;
    protected final boolean isJoin;
    protected Map<Object, AggregationRowPair> aggregatorsPerGroup;
    private AggregationRowPair currentAggregatorRow;
    private MethodResolutionService methodResolutionService;

    public AggSvcGroupByMixedAccessImpl(ExprEvaluator[] evaluators, AggregationMethodFactory[] prototypes, MethodResolutionService methodResolutionService, AggregationAccessorSlotPair[] accessorsFactory, AggregationStateFactory[] accessAggregations, boolean isJoin) {
        super(evaluators, prototypes);
        this.accessorsFactory = accessorsFactory;
        this.accessAggregations = accessAggregations;
        this.isJoin = isJoin;
        this.methodResolutionService = methodResolutionService;
        this.aggregatorsPerGroup = new HashMap<Object, AggregationRowPair>();
    }

    @Override
    public void clearResults(ExprEvaluatorContext exprEvaluatorContext) {
        this.aggregatorsPerGroup.clear();
    }

    @Override
    public void applyEnter(EventBean[] eventsPerStream, Object groupByKey, ExprEvaluatorContext exprEvaluatorContext) {
        AggregationRowPair groupAggregators = this.aggregatorsPerGroup.get(groupByKey);
        if (groupAggregators == null) {
            AggregationMethod[] methods = this.methodResolutionService.newAggregators(this.aggregators, exprEvaluatorContext.getAgentInstanceId(), groupByKey);
            AggregationState[] states = this.methodResolutionService.newAccesses(exprEvaluatorContext.getAgentInstanceId(), this.isJoin, this.accessAggregations, groupByKey);
            groupAggregators = new AggregationRowPair(methods, states);
            this.aggregatorsPerGroup.put(groupByKey, groupAggregators);
        }
        this.currentAggregatorRow = groupAggregators;
        AggregationMethod[] groupAggMethods = groupAggregators.getMethods();
        for (int j = 0; j < this.evaluators.length; ++j) {
            Object columnResult = this.evaluators[j].evaluate(eventsPerStream, true, exprEvaluatorContext);
            groupAggMethods[j].enter(columnResult);
        }
        for (AggregationState state : this.currentAggregatorRow.getStates()) {
            state.applyEnter(eventsPerStream, exprEvaluatorContext);
        }
        this.internalHandleUpdated(groupByKey, groupAggregators);
    }

    @Override
    public void applyLeave(EventBean[] eventsPerStream, Object groupByKey, ExprEvaluatorContext exprEvaluatorContext) {
        AggregationRowPair groupAggregators = this.aggregatorsPerGroup.get(groupByKey);
        if (groupAggregators == null) {
            AggregationMethod[] methods = this.methodResolutionService.newAggregators(this.aggregators, exprEvaluatorContext.getAgentInstanceId(), groupByKey);
            AggregationState[] states = this.methodResolutionService.newAccesses(exprEvaluatorContext.getAgentInstanceId(), this.isJoin, this.accessAggregations, groupByKey);
            groupAggregators = new AggregationRowPair(methods, states);
            this.aggregatorsPerGroup.put(groupByKey, groupAggregators);
        }
        this.currentAggregatorRow = groupAggregators;
        AggregationMethod[] groupAggMethods = groupAggregators.getMethods();
        for (int j = 0; j < this.evaluators.length; ++j) {
            Object columnResult = this.evaluators[j].evaluate(eventsPerStream, false, exprEvaluatorContext);
            groupAggMethods[j].leave(columnResult);
        }
        for (AggregationState state : this.currentAggregatorRow.getStates()) {
            state.applyLeave(eventsPerStream, exprEvaluatorContext);
        }
        this.internalHandleUpdated(groupByKey, groupAggregators);
    }

    @Override
    public void setCurrentAccess(Object groupByKey, int agentInstanceId) {
        this.currentAggregatorRow = this.aggregatorsPerGroup.get(groupByKey);
        if (this.currentAggregatorRow == null) {
            AggregationMethod[] methods = this.methodResolutionService.newAggregators(this.aggregators, agentInstanceId, groupByKey);
            AggregationState[] states = this.methodResolutionService.newAccesses(agentInstanceId, this.isJoin, this.accessAggregations, groupByKey);
            this.currentAggregatorRow = new AggregationRowPair(methods, states);
            this.aggregatorsPerGroup.put(groupByKey, this.currentAggregatorRow);
        }
    }

    @Override
    public Object getValue(int column, int agentInstanceId) {
        if (column < this.aggregators.length) {
            return this.currentAggregatorRow.getMethods()[column].getValue();
        }
        AggregationAccessorSlotPair pair = this.accessorsFactory[column - this.aggregators.length];
        return pair.getAccessor().getValue(this.currentAggregatorRow.getStates()[pair.getSlot()]);
    }

    @Override
    public Collection<EventBean> getCollection(int column, ExprEvaluatorContext context) {
        if (column < this.aggregators.length) {
            return null;
        }
        AggregationAccessorSlotPair pair = this.accessorsFactory[column - this.aggregators.length];
        return pair.getAccessor().getEnumerableEvents(this.currentAggregatorRow.getStates()[pair.getSlot()]);
    }

    @Override
    public EventBean getEventBean(int column, ExprEvaluatorContext context) {
        if (column < this.aggregators.length) {
            return null;
        }
        AggregationAccessorSlotPair pair = this.accessorsFactory[column - this.aggregators.length];
        return pair.getAccessor().getEnumerableEvent(this.currentAggregatorRow.getStates()[pair.getSlot()]);
    }

    @Override
    public void setRemovedCallback(AggregationRowRemovedCallback callback) {
    }

    public void internalHandleUpdated(Object groupByKey, AggregationRowPair groupAggregators) {
    }
}

