/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.service;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.agg.aggregator.AggregationMethod;
import com.espertech.esper.epl.agg.service.AggregationMethodFactory;
import com.espertech.esper.epl.agg.service.AggregationRowRemovedCallback;
import com.espertech.esper.epl.agg.service.AggregationServiceBaseGrouped;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class AggSvcGroupByNoAccessImpl
extends AggregationServiceBaseGrouped {
    private Map<Object, AggregationMethod[]> aggregatorsPerGroup;
    private AggregationMethod[] currentAggregatorRow;
    private MethodResolutionService methodResolutionService;

    public AggSvcGroupByNoAccessImpl(ExprEvaluator[] evaluators, AggregationMethodFactory[] prototypes, MethodResolutionService methodResolutionService) {
        super(evaluators, prototypes);
        this.methodResolutionService = methodResolutionService;
        this.aggregatorsPerGroup = new HashMap<Object, AggregationMethod[]>();
    }

    @Override
    public void clearResults(ExprEvaluatorContext exprEvaluatorContext) {
        this.aggregatorsPerGroup.clear();
    }

    @Override
    public void applyEnter(EventBean[] eventsPerStream, Object groupByKey, ExprEvaluatorContext exprEvaluatorContext) {
        AggregationMethod[] groupAggregators = this.aggregatorsPerGroup.get(groupByKey);
        if (groupAggregators == null) {
            groupAggregators = this.methodResolutionService.newAggregators(this.aggregators, exprEvaluatorContext.getAgentInstanceId(), groupByKey);
            this.aggregatorsPerGroup.put(groupByKey, groupAggregators);
        }
        this.currentAggregatorRow = groupAggregators;
        for (int j = 0; j < this.evaluators.length; ++j) {
            Object columnResult = this.evaluators[j].evaluate(eventsPerStream, true, exprEvaluatorContext);
            groupAggregators[j].enter(columnResult);
        }
    }

    @Override
    public void applyLeave(EventBean[] eventsPerStream, Object groupByKey, ExprEvaluatorContext exprEvaluatorContext) {
        AggregationMethod[] groupAggregators = this.aggregatorsPerGroup.get(groupByKey);
        if (groupAggregators == null) {
            groupAggregators = this.methodResolutionService.newAggregators(this.aggregators, exprEvaluatorContext.getAgentInstanceId(), groupByKey);
            this.aggregatorsPerGroup.put(groupByKey, groupAggregators);
        }
        this.currentAggregatorRow = groupAggregators;
        for (int j = 0; j < this.evaluators.length; ++j) {
            Object columnResult = this.evaluators[j].evaluate(eventsPerStream, false, exprEvaluatorContext);
            groupAggregators[j].leave(columnResult);
        }
    }

    @Override
    public void setCurrentAccess(Object groupByKey, int agentInstanceId) {
        this.currentAggregatorRow = this.aggregatorsPerGroup.get(groupByKey);
        if (this.currentAggregatorRow == null) {
            this.currentAggregatorRow = this.methodResolutionService.newAggregators(this.aggregators, agentInstanceId, groupByKey);
            this.aggregatorsPerGroup.put(groupByKey, this.currentAggregatorRow);
        }
    }

    @Override
    public Object getValue(int column, int agentInstanceId) {
        return this.currentAggregatorRow[column].getValue();
    }

    @Override
    public Collection<EventBean> getCollection(int column, ExprEvaluatorContext context) {
        return null;
    }

    @Override
    public EventBean getEventBean(int column, ExprEvaluatorContext context) {
        return null;
    }

    @Override
    public void setRemovedCallback(AggregationRowRemovedCallback callback) {
    }
}

