/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.service;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.agg.aggregator.AggregationMethod;
import com.espertech.esper.epl.agg.service.AggregationMethodFactory;
import com.espertech.esper.epl.agg.service.AggregationMethodRow;
import com.espertech.esper.epl.agg.service.AggregationRowRemovedCallback;
import com.espertech.esper.epl.agg.service.AggregationServiceBaseGrouped;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AggSvcGroupByRefcountedNoAccessImpl
extends AggregationServiceBaseGrouped {
    protected Map<Object, AggregationMethodRow> aggregatorsPerGroup;
    private AggregationMethod[] currentAggregatorRow;
    private MethodResolutionService methodResolutionService;
    private List<Object> removedKeys;

    public AggSvcGroupByRefcountedNoAccessImpl(ExprEvaluator[] evaluators, AggregationMethodFactory[] prototypes, MethodResolutionService methodResolutionService) {
        super(evaluators, prototypes);
        this.methodResolutionService = methodResolutionService;
        this.aggregatorsPerGroup = new HashMap<Object, AggregationMethodRow>();
        this.removedKeys = new ArrayList<Object>();
    }

    @Override
    public void clearResults(ExprEvaluatorContext exprEvaluatorContext) {
        this.aggregatorsPerGroup.clear();
    }

    @Override
    public void applyEnter(EventBean[] eventsPerStream, Object groupByKey, ExprEvaluatorContext exprEvaluatorContext) {
        AggregationMethod[] groupAggregators;
        this.handleRemovedKeys();
        AggregationMethodRow row = this.aggregatorsPerGroup.get(groupByKey);
        if (row == null) {
            groupAggregators = this.methodResolutionService.newAggregators(this.aggregators, exprEvaluatorContext.getAgentInstanceId(), groupByKey);
            row = new AggregationMethodRow(this.methodResolutionService.getCurrentRowCount(groupAggregators, null) + 1L, groupAggregators);
            this.aggregatorsPerGroup.put(groupByKey, row);
        } else {
            groupAggregators = row.getMethods();
            row.increaseRefcount();
        }
        this.currentAggregatorRow = groupAggregators;
        for (int j = 0; j < this.evaluators.length; ++j) {
            Object columnResult = this.evaluators[j].evaluate(eventsPerStream, true, exprEvaluatorContext);
            groupAggregators[j].enter(columnResult);
        }
    }

    @Override
    public void applyLeave(EventBean[] eventsPerStream, Object groupByKey, ExprEvaluatorContext exprEvaluatorContext) {
        AggregationMethod[] groupAggregators;
        AggregationMethodRow row = this.aggregatorsPerGroup.get(groupByKey);
        if (row != null) {
            groupAggregators = row.getMethods();
        } else {
            groupAggregators = this.methodResolutionService.newAggregators(this.aggregators, exprEvaluatorContext.getAgentInstanceId(), groupByKey);
            row = new AggregationMethodRow(this.methodResolutionService.getCurrentRowCount(groupAggregators, null) + 1L, groupAggregators);
            this.aggregatorsPerGroup.put(groupByKey, row);
        }
        this.currentAggregatorRow = groupAggregators;
        for (int j = 0; j < this.evaluators.length; ++j) {
            Object columnResult = this.evaluators[j].evaluate(eventsPerStream, false, exprEvaluatorContext);
            groupAggregators[j].leave(columnResult);
        }
        row.decreaseRefcount();
        if (row.getRefcount() <= 0L) {
            this.removedKeys.add(groupByKey);
            this.methodResolutionService.removeAggregators(exprEvaluatorContext.getAgentInstanceId(), groupByKey);
        }
    }

    @Override
    public void setCurrentAccess(Object groupByKey, int agentInstanceId) {
        AggregationMethodRow row = this.aggregatorsPerGroup.get(groupByKey);
        this.currentAggregatorRow = row != null ? row.getMethods() : null;
        if (this.currentAggregatorRow == null) {
            this.currentAggregatorRow = this.methodResolutionService.newAggregators(this.aggregators, agentInstanceId, groupByKey);
        }
    }

    @Override
    public Object getValue(int column, int agentInstanceId) {
        return this.currentAggregatorRow[column].getValue();
    }

    @Override
    public Collection<EventBean> getCollection(int column, ExprEvaluatorContext context) {
        return null;
    }

    @Override
    public EventBean getEventBean(int column, ExprEvaluatorContext context) {
        return null;
    }

    @Override
    public void setRemovedCallback(AggregationRowRemovedCallback callback) {
    }

    protected void handleRemovedKeys() {
        if (!this.removedKeys.isEmpty()) {
            for (Object removedKey : this.removedKeys) {
                this.aggregatorsPerGroup.remove(removedKey);
            }
            this.removedKeys.clear();
        }
    }
}

