/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.service;

import com.espertech.esper.epl.agg.access.AggregationAccessor;
import com.espertech.esper.epl.agg.access.AggregationAccessorSlotPair;
import com.espertech.esper.epl.agg.access.AggregationStateKey;
import com.espertech.esper.epl.agg.service.AggregationMultiFunctionAnalysisResult;
import com.espertech.esper.epl.agg.service.AggregationServiceAggExpressionDesc;
import com.espertech.esper.epl.agg.service.AggregationStateFactory;
import com.espertech.esper.epl.expression.ExprAggregateNode;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class AggregationMultiFunctionAnalysisHelper {
    public static AggregationMultiFunctionAnalysisResult analyzeAccessAggregations(List<AggregationServiceAggExpressionDesc> aggregations) {
        int currentSlot = 0;
        LinkedHashMap<AggregationStateKey, Integer> accessProviderSlots = new LinkedHashMap<AggregationStateKey, Integer>();
        ArrayList<AggregationAccessorSlotPair> accessorPairs = new ArrayList<AggregationAccessorSlotPair>();
        ArrayList<AggregationStateFactory> stateFactories = new ArrayList<AggregationStateFactory>();
        for (AggregationServiceAggExpressionDesc aggregation : aggregations) {
            ExprAggregateNode aggregateNode = aggregation.getAggregationNode();
            if (!aggregateNode.getFactory().isAccessAggregation()) continue;
            AggregationStateKey providerKey = aggregateNode.getFactory().getAggregationStateKey(false);
            AggregationAccessor accessor = aggregateNode.getFactory().getAccessor();
            Integer slot = (Integer)accessProviderSlots.get(providerKey);
            if (slot == null) {
                accessProviderSlots.put(providerKey, currentSlot);
                slot = currentSlot++;
                AggregationStateFactory providerFactory = aggregateNode.getFactory().getAggregationStateFactory(false);
                stateFactories.add(providerFactory);
            }
            accessorPairs.add(new AggregationAccessorSlotPair(slot, accessor));
        }
        AggregationAccessorSlotPair[] pairs = accessorPairs.toArray(new AggregationAccessorSlotPair[accessorPairs.size()]);
        AggregationStateFactory[] accessAggregations = stateFactories.toArray(new AggregationStateFactory[stateFactories.size()]);
        return new AggregationMultiFunctionAnalysisResult(pairs, accessAggregations);
    }
}

