/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.service;

import com.espertech.esper.epl.agg.service.AggregationMethodFactory;
import com.espertech.esper.epl.agg.service.AggregationResultFuture;
import com.espertech.esper.epl.expression.ExprAggregateNode;
import java.util.ArrayList;
import java.util.List;

public class AggregationServiceAggExpressionDesc {
    private ExprAggregateNode aggregationNode;
    private AggregationMethodFactory factory;
    private List<ExprAggregateNode> equivalentNodes;
    private Integer columnNum;

    public AggregationServiceAggExpressionDesc(ExprAggregateNode aggregationNode, AggregationMethodFactory factory) {
        this.aggregationNode = aggregationNode;
        this.factory = factory;
    }

    public List<ExprAggregateNode> getEquivalentNodes() {
        return this.equivalentNodes;
    }

    public AggregationMethodFactory getFactory() {
        return this.factory;
    }

    public Integer getColumnNum() {
        return this.columnNum;
    }

    public void setColumnNum(Integer columnNum) {
        this.columnNum = columnNum;
    }

    public void addEquivalent(ExprAggregateNode aggNodeToAdd) {
        if (this.equivalentNodes == null) {
            this.equivalentNodes = new ArrayList<ExprAggregateNode>();
        }
        this.equivalentNodes.add(aggNodeToAdd);
    }

    public ExprAggregateNode getAggregationNode() {
        return this.aggregationNode;
    }

    public void assignFuture(AggregationResultFuture service) {
        this.aggregationNode.setAggregationResultFuture(service, this.columnNum);
        if (this.equivalentNodes == null) {
            return;
        }
        for (ExprAggregateNode equivalentAggNode : this.equivalentNodes) {
            equivalentAggNode.setAggregationResultFuture(service, this.columnNum);
        }
    }
}

