/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.service;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.annotation.Hint;
import com.espertech.esper.client.annotation.HintEnum;
import com.espertech.esper.epl.agg.access.AggregationAccessorSlotPair;
import com.espertech.esper.epl.agg.service.AggregationMethodFactory;
import com.espertech.esper.epl.agg.service.AggregationMultiFunctionAnalysisHelper;
import com.espertech.esper.epl.agg.service.AggregationMultiFunctionAnalysisResult;
import com.espertech.esper.epl.agg.service.AggregationServiceAggExpressionDesc;
import com.espertech.esper.epl.agg.service.AggregationServiceFactory;
import com.espertech.esper.epl.agg.service.AggregationServiceFactoryDesc;
import com.espertech.esper.epl.agg.service.AggregationServiceFactoryService;
import com.espertech.esper.epl.agg.service.AggregationServiceMatchRecognizeFactoryDesc;
import com.espertech.esper.epl.agg.service.AggregationServiceMatchRecognizeFactoryImpl;
import com.espertech.esper.epl.agg.service.AggregationStateFactory;
import com.espertech.esper.epl.expression.ExprAggregateNode;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodePreviousVisitorWParent;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprNumberSetWildcardMarker;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.variable.VariableService;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class AggregationServiceFactoryFactory {
    public static AggregationServiceMatchRecognizeFactoryDesc getServiceMatchRecognize(int numStreams, Map<Integer, List<ExprAggregateNode>> measureExprNodesPerStream, ExprEvaluatorContext exprEvaluatorContext) {
        TreeMap<Integer, ArrayList<AggregationServiceAggExpressionDesc>> equivalencyListPerStream = new TreeMap<Integer, ArrayList<AggregationServiceAggExpressionDesc>>();
        for (Map.Entry<Integer, List<ExprAggregateNode>> entry : measureExprNodesPerStream.entrySet()) {
            ArrayList<AggregationServiceAggExpressionDesc> equivalencyList = new ArrayList<AggregationServiceAggExpressionDesc>();
            equivalencyListPerStream.put(entry.getKey(), equivalencyList);
            for (ExprAggregateNode selectAggNode : entry.getValue()) {
                AggregationServiceFactoryFactory.addEquivalent(selectAggNode, equivalencyList);
            }
        }
        LinkedHashMap<Integer, AggregationMethodFactory[]> aggregatorsPerStream = new LinkedHashMap<Integer, AggregationMethodFactory[]>();
        HashMap<Integer, ExprEvaluator[]> evaluatorsPerStream = new HashMap<Integer, ExprEvaluator[]>();
        for (Map.Entry equivalencyPerStream : equivalencyListPerStream.entrySet()) {
            int index = 0;
            int stream = (Integer)equivalencyPerStream.getKey();
            AggregationMethodFactory[] aggregators = new AggregationMethodFactory[((List)equivalencyPerStream.getValue()).size()];
            aggregatorsPerStream.put(stream, aggregators);
            ExprEvaluator[] evaluators = new ExprEvaluator[((List)equivalencyPerStream.getValue()).size()];
            evaluatorsPerStream.put(stream, evaluators);
            for (AggregationServiceAggExpressionDesc aggregation : (List)equivalencyPerStream.getValue()) {
                ExprAggregateNode aggregateNode = aggregation.getAggregationNode();
                evaluators[index] = aggregateNode.getChildNodes().length > 1 ? AggregationServiceFactoryFactory.getMultiNodeEvaluator(aggregateNode.getChildNodes(), exprEvaluatorContext) : (aggregateNode.getChildNodes().length > 0 ? aggregateNode.getChildNodes()[0].getExprEvaluator() : new ExprEvaluator(){

                    @Override
                    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                        return null;
                    }

                    @Override
                    public Class getType() {
                        return null;
                    }

                    @Override
                    public Map<String, Object> getEventType() {
                        return null;
                    }
                });
                aggregators[index] = aggregateNode.getFactory();
                ++index;
            }
        }
        int columnNumber = 0;
        ArrayList<AggregationServiceAggExpressionDesc> allExpressions = new ArrayList<AggregationServiceAggExpressionDesc>();
        for (Map.Entry equivalencyPerStream : equivalencyListPerStream.entrySet()) {
            for (AggregationServiceAggExpressionDesc entry : (List)equivalencyPerStream.getValue()) {
                entry.setColumnNum(columnNumber++);
            }
            allExpressions.addAll((Collection)equivalencyPerStream.getValue());
        }
        AggregationServiceMatchRecognizeFactoryImpl factory = new AggregationServiceMatchRecognizeFactoryImpl(numStreams, aggregatorsPerStream, evaluatorsPerStream);
        return new AggregationServiceMatchRecognizeFactoryDesc(factory, allExpressions);
    }

    public static AggregationServiceFactoryDesc getService(List<ExprAggregateNode> selectAggregateExprNodes, List<ExprAggregateNode> havingAggregateExprNodes, List<ExprAggregateNode> orderByAggregateExprNodes, boolean hasGroupByClause, ExprEvaluatorContext exprEvaluatorContext, Annotation[] annotations, VariableService variableService, boolean isJoin, ExprNode whereClause, ExprNode havingClause, AggregationServiceFactoryService factoryService, EventType[] typesPerStream) throws ExprValidationException {
        AggregationServiceFactory serviceFactory;
        if (selectAggregateExprNodes.isEmpty() && havingAggregateExprNodes.isEmpty()) {
            return new AggregationServiceFactoryDesc(factoryService.getNullAggregationService(), Collections.<AggregationServiceAggExpressionDesc>emptyList());
        }
        if (whereClause != null || havingClause != null) {
            ExprNodePreviousVisitorWParent visitor = new ExprNodePreviousVisitorWParent();
            if (whereClause != null) {
                whereClause.accept(visitor);
            }
            if (havingClause != null) {
                havingClause.accept(visitor);
            }
            if (visitor.getPrevious() != null && !visitor.getPrevious().isEmpty()) {
                String funcname = visitor.getPrevious().get(0).getSecond().getPreviousType().toString().toLowerCase();
                throw new ExprValidationException("The '" + funcname + "' function may not occur in the where-clause or having-clause of a statement with aggregations as 'previous' does not provide remove stream data; Use the 'first','last','window' or 'count' aggregation functions instead");
            }
        }
        ArrayList<AggregationServiceAggExpressionDesc> aggregations = new ArrayList<AggregationServiceAggExpressionDesc>();
        for (ExprAggregateNode selectAggNode : selectAggregateExprNodes) {
            AggregationServiceFactoryFactory.addEquivalent(selectAggNode, aggregations);
        }
        for (ExprAggregateNode havingAggNode : havingAggregateExprNodes) {
            AggregationServiceFactoryFactory.addEquivalent(havingAggNode, aggregations);
        }
        for (ExprAggregateNode orderByAggNode : orderByAggregateExprNodes) {
            AggregationServiceFactoryFactory.addEquivalent(orderByAggNode, aggregations);
        }
        int columnNumber = 0;
        for (AggregationServiceAggExpressionDesc entry : aggregations) {
            if (entry.getFactory().isAccessAggregation()) continue;
            entry.setColumnNum(columnNumber++);
        }
        for (AggregationServiceAggExpressionDesc entry : aggregations) {
            if (!entry.getFactory().isAccessAggregation()) continue;
            entry.setColumnNum(columnNumber++);
        }
        ArrayList<AggregationMethodFactory> aggregators = new ArrayList<AggregationMethodFactory>();
        ArrayList<ExprEvaluator> evaluators = new ArrayList<ExprEvaluator>();
        for (AggregationServiceAggExpressionDesc aggregation : aggregations) {
            ExprEvaluator evaluator;
            ExprAggregateNode aggregateNode = aggregation.getAggregationNode();
            if (aggregateNode.getFactory().isAccessAggregation()) continue;
            if (aggregateNode.getChildNodes().length > 1) {
                evaluator = AggregationServiceFactoryFactory.getMultiNodeEvaluator(aggregateNode.getChildNodes(), exprEvaluatorContext);
            } else if (aggregateNode.getChildNodes().length > 0) {
                if (aggregateNode.getChildNodes()[0] instanceof ExprNumberSetWildcardMarker) {
                    Class returnType;
                    Class clazz = returnType = typesPerStream != null && typesPerStream.length > 0 ? typesPerStream[0].getUnderlyingType() : null;
                    if (isJoin || returnType == null) {
                        throw new ExprValidationException("Invalid use of wildcard (*) for stream selection in a join or an empty from-clause, please use the stream-alias syntax to select a specific stream instead");
                    }
                    evaluator = new ExprEvaluator(){

                        @Override
                        public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                            return eventsPerStream[0].getUnderlying();
                        }

                        @Override
                        public Class getType() {
                            return returnType;
                        }

                        @Override
                        public Map<String, Object> getEventType() {
                            return null;
                        }
                    };
                } else {
                    evaluator = aggregateNode.getChildNodes()[0].getExprEvaluator();
                }
            } else {
                evaluator = new ExprEvaluator(){

                    @Override
                    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                        return null;
                    }

                    @Override
                    public Class getType() {
                        return null;
                    }

                    @Override
                    public Map<String, Object> getEventType() {
                        return null;
                    }
                };
            }
            AggregationMethodFactory aggregator = aggregateNode.getFactory();
            evaluators.add(evaluator);
            aggregators.add(aggregator);
        }
        ExprEvaluator[] evaluatorsArr = evaluators.toArray(new ExprEvaluator[evaluators.size()]);
        AggregationMethodFactory[] aggregatorsArr = aggregators.toArray(new AggregationMethodFactory[aggregators.size()]);
        AggregationMultiFunctionAnalysisResult multiFunctionAggPlan = AggregationMultiFunctionAnalysisHelper.analyzeAccessAggregations(aggregations);
        AggregationAccessorSlotPair[] accessorPairs = multiFunctionAggPlan.getAccessorPairs();
        AggregationStateFactory[] accessAggregations = multiFunctionAggPlan.getStateFactories();
        if (!hasGroupByClause) {
            serviceFactory = evaluatorsArr.length > 0 && accessorPairs.length == 0 ? factoryService.getNoGroupNoAccess(evaluatorsArr, aggregatorsArr) : (evaluatorsArr.length == 0 && accessorPairs.length > 0 ? factoryService.getNoGroupAccessOnly(accessorPairs, accessAggregations, isJoin) : factoryService.getNoGroupAccessMixed(evaluatorsArr, aggregatorsArr, accessorPairs, accessAggregations, isJoin));
        } else {
            boolean hasNoReclaim = HintEnum.DISABLE_RECLAIM_GROUP.getHint(annotations) != null;
            Hint reclaimGroupAged = HintEnum.RECLAIM_GROUP_AGED.getHint(annotations);
            Hint reclaimGroupFrequency = HintEnum.RECLAIM_GROUP_AGED.getHint(annotations);
            serviceFactory = hasNoReclaim ? (evaluatorsArr.length > 0 && accessorPairs.length == 0 ? factoryService.getGroupedNoReclaimNoAccess(evaluatorsArr, aggregatorsArr) : (evaluatorsArr.length == 0 && accessorPairs.length > 0 ? factoryService.getGroupNoReclaimAccessOnly(accessorPairs, accessAggregations, isJoin) : factoryService.getGroupNoReclaimMixed(evaluatorsArr, aggregatorsArr, accessorPairs, accessAggregations, isJoin))) : (reclaimGroupAged != null ? factoryService.getGroupReclaimAged(evaluatorsArr, aggregatorsArr, reclaimGroupAged, reclaimGroupFrequency, variableService, accessorPairs, accessAggregations, isJoin) : (evaluatorsArr.length > 0 && accessorPairs.length == 0 ? factoryService.getGroupReclaimNoAccess(evaluatorsArr, aggregatorsArr, accessorPairs, accessAggregations, isJoin) : factoryService.getGroupReclaimMixable(evaluatorsArr, aggregatorsArr, accessorPairs, accessAggregations, isJoin)));
        }
        return new AggregationServiceFactoryDesc(serviceFactory, aggregations);
    }

    private static ExprEvaluator getMultiNodeEvaluator(ExprNode[] childNodes, ExprEvaluatorContext exprEvaluatorContext) {
        int size = childNodes.length;
        final ExprNode[] exprNodes = childNodes;
        final Object[] prototype = new Object[size];
        int count = 0;
        for (ExprNode node : exprNodes) {
            if (node.isConstantResult()) {
                prototype[count] = node.getExprEvaluator().evaluate(null, true, exprEvaluatorContext);
            }
            ++count;
        }
        return new ExprEvaluator(){

            @Override
            public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                int count = 0;
                for (ExprNode node : exprNodes) {
                    prototype[count] = node.getExprEvaluator().evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
                    ++count;
                }
                return prototype;
            }

            @Override
            public Class getType() {
                return Object[].class;
            }

            @Override
            public Map<String, Object> getEventType() {
                return null;
            }
        };
    }

    private static void addEquivalent(ExprAggregateNode aggNodeToAdd, List<AggregationServiceAggExpressionDesc> equivalencyList) {
        boolean foundEquivalent = false;
        for (AggregationServiceAggExpressionDesc existing : equivalencyList) {
            ExprAggregateNode aggNode = existing.getAggregationNode();
            if (!ExprNodeUtility.deepEquals(aggNode, aggNodeToAdd)) continue;
            existing.addEquivalent(aggNodeToAdd);
            foundEquivalent = true;
            break;
        }
        if (!foundEquivalent) {
            equivalencyList.add(new AggregationServiceAggExpressionDesc(aggNodeToAdd, aggNodeToAdd.getFactory()));
        }
    }
}

