/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.epl.expression.ExprIdentNode;
import com.espertech.esper.epl.expression.ExprNode;

public class ColumnNamedNodeSwapper {
    public static ExprNode swap(ExprNode exprTree, String columnName, ExprNode fullExpr) {
        if (fullExpr == null) {
            throw new NullPointerException();
        }
        if (ColumnNamedNodeSwapper.isColumnNameNode(exprTree, columnName)) {
            return fullExpr;
        }
        ColumnNamedNodeSwapper.visitChildren(exprTree, columnName, fullExpr);
        return exprTree;
    }

    private static void visitChildren(ExprNode node, String name, ExprNode fullExpr) {
        ExprNode[] childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.length; ++i) {
            ExprNode childNode = childNodes[i];
            if (ColumnNamedNodeSwapper.isColumnNameNode(childNode, name)) {
                node.setChildNode(i, fullExpr);
                continue;
            }
            ColumnNamedNodeSwapper.visitChildren(childNode, name, fullExpr);
        }
    }

    private static boolean isColumnNameNode(ExprNode node, String name) {
        if (node instanceof ExprIdentNode) {
            if (node.getChildNodes().length > 0) {
                throw new IllegalStateException("Ident node has unexpected child nodes");
            }
            ExprIdentNode identNode = (ExprIdentNode)node;
            return identNode.getUnresolvedPropertyName().equals(name) && identNode.getStreamOrPropertyName() == null;
        }
        return false;
    }
}

