/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.db.PollExecStrategy;
import com.espertech.esper.event.EventAdapterService;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.cglib.reflect.FastMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MethodPollingExecStrategy
implements PollExecStrategy {
    private static final Log log = LogFactory.getLog(MethodPollingExecStrategy.class);
    private final EventAdapterService eventAdapterService;
    private final FastMethod method;
    private boolean isArray;
    private boolean useMapType;
    private EventType eventType;

    public MethodPollingExecStrategy(EventAdapterService eventAdapterService, FastMethod method, boolean useMapType, EventType eventType) {
        this.eventAdapterService = eventAdapterService;
        this.method = method;
        this.isArray = method.getReturnType().isArray();
        this.useMapType = useMapType;
        this.eventType = eventType;
    }

    @Override
    public void start() {
    }

    @Override
    public void done() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public List<EventBean> poll(Object[] lookupValues) {
        AbstractList rowResult = null;
        try {
            Object invocationResult = this.method.invoke(null, lookupValues);
            if (invocationResult != null) {
                if (this.isArray) {
                    int length = Array.getLength(invocationResult);
                    if (length > 0) {
                        rowResult = new ArrayList();
                        for (int i = 0; i < length; ++i) {
                            EventBean theEvent;
                            Object value = Array.get(invocationResult, i);
                            if (value == null) {
                                log.warn((Object)("Expected non-null return result from method '" + this.method.getName() + "', but received null value"));
                                continue;
                            }
                            if (this.useMapType) {
                                if (!(value instanceof Map)) {
                                    log.warn((Object)("Expected Map-type return result from method '" + this.method.getName() + "', but received type '" + value.getClass() + "'"));
                                    continue;
                                }
                                Map mapValues = (Map)value;
                                theEvent = this.eventAdapterService.adapterForTypedMap(mapValues, this.eventType);
                            } else {
                                theEvent = this.eventAdapterService.adapterForBean(value);
                            }
                            rowResult.add(theEvent);
                        }
                    }
                } else {
                    rowResult = new LinkedList();
                    if (this.useMapType) {
                        if (!(invocationResult instanceof Map)) {
                            log.warn((Object)("Expected Map-type return result from method '" + this.method.getName() + "', but received type '" + invocationResult.getClass() + "'"));
                        } else {
                            Map mapValues = (Map)invocationResult;
                            EventBean theEvent = this.eventAdapterService.adapterForTypedMap(mapValues, this.eventType);
                            rowResult.add(theEvent);
                        }
                    } else {
                        EventBean theEvent = this.eventAdapterService.adapterForBean(invocationResult);
                        rowResult.add(theEvent);
                    }
                }
            }
        }
        catch (InvocationTargetException ex) {
            throw new EPException("Method '" + this.method.getName() + "' of class '" + this.method.getJavaMethod().getDeclaringClass().getName() + "' reported an exception: " + ex.getTargetException(), ex.getTargetException());
        }
        return rowResult;
    }
}

