/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.epl.agg.service.AggregationService;
import com.espertech.esper.epl.core.OrderByElement;
import com.espertech.esper.epl.core.OrderByProcessor;
import com.espertech.esper.epl.core.OrderByProcessorFactory;
import com.espertech.esper.epl.core.OrderByProcessorImpl;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.OrderByItem;
import com.espertech.esper.util.CollectionUtil;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OrderByProcessorFactoryImpl
implements OrderByProcessorFactory {
    private static final Log log = LogFactory.getLog(OrderByProcessorFactoryImpl.class);
    private final OrderByElement[] orderBy;
    private final ExprEvaluator[] groupByNodes;
    private final boolean needsGroupByKeys;
    private final Comparator<Object> comparator;

    public OrderByProcessorFactoryImpl(List<OrderByItem> orderByList, ExprNode[] groupByNodes, boolean needsGroupByKeys, boolean isSortUsingCollator) throws ExprValidationException {
        this.orderBy = this.toElementArray(orderByList);
        this.groupByNodes = ExprNodeUtility.getEvaluators(groupByNodes);
        this.needsGroupByKeys = needsGroupByKeys;
        this.comparator = OrderByProcessorFactoryImpl.getComparator(this.orderBy, isSortUsingCollator);
    }

    @Override
    public OrderByProcessor instantiate(AggregationService aggregationService) {
        return new OrderByProcessorImpl(this, aggregationService);
    }

    public OrderByElement[] getOrderBy() {
        return this.orderBy;
    }

    public ExprEvaluator[] getGroupByNodes() {
        return this.groupByNodes;
    }

    public boolean isNeedsGroupByKeys() {
        return this.needsGroupByKeys;
    }

    public Comparator<Object> getComparator() {
        return this.comparator;
    }

    protected static Comparator<Object> getComparator(OrderByElement[] orderBy, boolean isSortUsingCollator) throws ExprValidationException {
        ExprEvaluator[] evaluators = new ExprEvaluator[orderBy.length];
        boolean[] descending = new boolean[orderBy.length];
        for (int i = 0; i < orderBy.length; ++i) {
            evaluators[i] = orderBy[i].getExpr();
            descending[i] = orderBy[i].isDescending();
        }
        return CollectionUtil.getComparator(evaluators, isSortUsingCollator, descending);
    }

    private OrderByElement[] toElementArray(List<OrderByItem> orderByList) {
        OrderByElement[] elements = new OrderByElement[orderByList.size()];
        int count = 0;
        for (OrderByItem item : orderByList) {
            elements[count++] = new OrderByElement(item.getExprNode().getExprEvaluator(), item.isDescending());
        }
        return elements;
    }
}

