/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.epl.agg.service.AggregationService;
import com.espertech.esper.epl.core.OrderByProcessor;
import com.espertech.esper.epl.core.OrderByProcessorFactory;
import com.espertech.esper.epl.core.OrderByProcessorImpl;
import com.espertech.esper.epl.core.OrderByProcessorRowLimit;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.RowLimitSpec;
import com.espertech.esper.epl.variable.VariableReader;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.util.JavaClassHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OrderByProcessorRowLimitFactory
implements OrderByProcessorFactory {
    private static final Log log = LogFactory.getLog(OrderByProcessorImpl.class);
    private final VariableReader numRowsVariableReader;
    private final VariableReader offsetVariableReader;
    private int currentRowLimit;
    private int currentOffset;

    public OrderByProcessorRowLimitFactory(RowLimitSpec rowLimitSpec, VariableService variableService) throws ExprValidationException {
        if (rowLimitSpec.getNumRowsVariable() != null) {
            this.numRowsVariableReader = variableService.getReader(rowLimitSpec.getNumRowsVariable());
            if (this.numRowsVariableReader == null) {
                throw new ExprValidationException("Limit clause variable by name '" + rowLimitSpec.getNumRowsVariable() + "' has not been declared");
            }
            if (!JavaClassHelper.isNumeric(this.numRowsVariableReader.getType())) {
                throw new ExprValidationException("Limit clause requires a variable of numeric type");
            }
        } else {
            this.numRowsVariableReader = null;
            this.currentRowLimit = rowLimitSpec.getNumRows();
            if (this.currentRowLimit < 0) {
                this.currentRowLimit = Integer.MAX_VALUE;
            }
        }
        if (rowLimitSpec.getOptionalOffsetVariable() != null) {
            this.offsetVariableReader = variableService.getReader(rowLimitSpec.getOptionalOffsetVariable());
            if (this.offsetVariableReader == null) {
                throw new ExprValidationException("Limit clause variable by name '" + rowLimitSpec.getOptionalOffsetVariable() + "' has not been declared");
            }
            if (!JavaClassHelper.isNumeric(this.offsetVariableReader.getType())) {
                throw new ExprValidationException("Limit clause requires a variable of numeric type");
            }
        } else {
            this.offsetVariableReader = null;
            if (rowLimitSpec.getOptionalOffset() != null) {
                this.currentOffset = rowLimitSpec.getOptionalOffset();
                if (this.currentOffset <= 0) {
                    throw new ExprValidationException("Limit clause requires a positive offset");
                }
            } else {
                this.currentOffset = 0;
            }
        }
    }

    @Override
    public OrderByProcessor instantiate(AggregationService aggregationService) {
        return new OrderByProcessorRowLimit(this.numRowsVariableReader, this.offsetVariableReader, this.currentRowLimit, this.currentOffset);
    }
}

