/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.agg.service.AggregationService;
import com.espertech.esper.epl.core.OrderByProcessor;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.core.ResultSetProcessorFactory;
import com.espertech.esper.epl.core.ResultSetProcessorRowPerGroup;
import com.espertech.esper.epl.core.ResultSetProcessorRowPerGroupSpecial;
import com.espertech.esper.epl.core.SelectExprProcessor;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.spec.OutputLimitLimitType;
import com.espertech.esper.epl.spec.OutputLimitSpec;

public class ResultSetProcessorRowPerGroupFactory
implements ResultSetProcessorFactory {
    private final SelectExprProcessor selectExprProcessor;
    private final ExprEvaluator groupKeyNode;
    private final ExprEvaluator[] groupKeyNodes;
    private final ExprEvaluator optionalHavingNode;
    private final boolean isSorting;
    private final boolean isSelectRStream;
    private final boolean isUnidirectional;
    private final OutputLimitSpec outputLimitSpec;
    private final boolean noDataWindowSingleSnapshot;

    public ResultSetProcessorRowPerGroupFactory(SelectExprProcessor selectExprProcessor, ExprEvaluator[] groupKeyNodes, ExprEvaluator optionalHavingNode, boolean isSelectRStream, boolean isUnidirectional, OutputLimitSpec outputLimitSpec, boolean isSorting, boolean noDataWindowSingleStream) {
        this.selectExprProcessor = selectExprProcessor;
        this.groupKeyNodes = groupKeyNodes;
        this.groupKeyNode = groupKeyNodes.length == 1 ? groupKeyNodes[0] : null;
        this.optionalHavingNode = optionalHavingNode;
        this.isSorting = isSorting;
        this.isSelectRStream = isSelectRStream;
        this.isUnidirectional = isUnidirectional;
        this.outputLimitSpec = outputLimitSpec;
        this.noDataWindowSingleSnapshot = outputLimitSpec != null && outputLimitSpec.getDisplayLimit() == OutputLimitLimitType.SNAPSHOT && noDataWindowSingleStream;
    }

    @Override
    public ResultSetProcessor instantiate(OrderByProcessor orderByProcessor, AggregationService aggregationService, AgentInstanceContext agentInstanceContext) {
        if (this.noDataWindowSingleSnapshot) {
            return new ResultSetProcessorRowPerGroupSpecial(this, this.selectExprProcessor, orderByProcessor, aggregationService, agentInstanceContext);
        }
        return new ResultSetProcessorRowPerGroup(this, this.selectExprProcessor, orderByProcessor, aggregationService, agentInstanceContext);
    }

    @Override
    public EventType getResultEventType() {
        return this.selectExprProcessor.getResultEventType();
    }

    @Override
    public boolean hasAggregation() {
        return true;
    }

    public ExprEvaluator[] getGroupKeyNodes() {
        return this.groupKeyNodes;
    }

    public ExprEvaluator getGroupKeyNode() {
        return this.groupKeyNode;
    }

    public ExprEvaluator getOptionalHavingNode() {
        return this.optionalHavingNode;
    }

    public boolean isSorting() {
        return this.isSorting;
    }

    public boolean isSelectRStream() {
        return this.isSelectRStream;
    }

    public boolean isUnidirectional() {
        return this.isUnidirectional;
    }

    public OutputLimitSpec getOutputLimitSpec() {
        return this.outputLimitSpec;
    }
}

