/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.agg.service.AggregationRowRemovedCallback;
import com.espertech.esper.epl.agg.service.AggregationService;
import com.espertech.esper.epl.core.OrderByProcessor;
import com.espertech.esper.epl.core.ResultSetProcessorRowPerGroup;
import com.espertech.esper.epl.core.ResultSetProcessorRowPerGroupFactory;
import com.espertech.esper.epl.core.ResultSetRowPerGroupIterator;
import com.espertech.esper.epl.core.SelectExprProcessor;
import com.espertech.esper.view.Viewable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResultSetProcessorRowPerGroupSpecial
extends ResultSetProcessorRowPerGroup
implements AggregationRowRemovedCallback {
    private static final Log log = LogFactory.getLog(ResultSetProcessorRowPerGroupSpecial.class);
    protected final Map<Object, EventBean> groupReps = new LinkedHashMap<Object, EventBean>();

    public ResultSetProcessorRowPerGroupSpecial(ResultSetProcessorRowPerGroupFactory prototype, SelectExprProcessor selectExprProcessor, OrderByProcessor orderByProcessor, AggregationService aggregationService, AgentInstanceContext agentInstanceContext) {
        super(prototype, selectExprProcessor, orderByProcessor, aggregationService, agentInstanceContext);
        aggregationService.setRemovedCallback(this);
    }

    @Override
    public UniformPair<EventBean[]> processViewResult(EventBean[] newData, EventBean[] oldData, boolean isSynthesize) {
        EventBean[] selectNewEvents;
        int i;
        HashMap<Object, EventBean> keysAndEvents = new HashMap<Object, EventBean>();
        Object[] newDataMultiKey = this.generateGroupKeys(newData, keysAndEvents, true);
        Object[] oldDataMultiKey = this.generateGroupKeys(oldData, keysAndEvents, false);
        EventBean[] selectOldEvents = null;
        if (this.prototype.isSelectRStream()) {
            selectOldEvents = this.generateOutputEventsView(keysAndEvents, false, isSynthesize);
        }
        EventBean[] eventsPerStream = new EventBean[1];
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                eventsPerStream[0] = newData[i];
                this.groupReps.put(newDataMultiKey[i], eventsPerStream[0]);
                this.aggregationService.applyEnter(eventsPerStream, newDataMultiKey[i], this.agentInstanceContext);
            }
        }
        if (oldData != null) {
            for (i = 0; i < oldData.length; ++i) {
                eventsPerStream[0] = oldData[i];
                this.aggregationService.applyLeave(eventsPerStream, oldDataMultiKey[i], this.agentInstanceContext);
            }
        }
        if ((selectNewEvents = this.generateOutputEventsView(keysAndEvents, true, isSynthesize)) != null || selectOldEvents != null) {
            return new UniformPair<EventBean[]>(selectNewEvents, selectOldEvents);
        }
        return null;
    }

    @Override
    public Iterator<EventBean> getIterator(Viewable parent) {
        if (this.orderByProcessor == null) {
            Iterator<EventBean> it = this.groupReps.values().iterator();
            return new ResultSetRowPerGroupIterator(it, this, this.aggregationService, this.agentInstanceContext);
        }
        return this.getIteratorSorted(this.groupReps.values().iterator());
    }

    @Override
    public void removed(Object optionalGroupKeyPerRow) {
        this.groupReps.remove(optionalGroupKeyPerRow);
    }
}

