/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.ConfigurationInformation;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.SelectExprEventTypeRegistry;
import com.espertech.esper.epl.core.SelectExprInsertEventBeanFactory;
import com.espertech.esper.epl.core.SelectExprJoinWildcardProcessorMap;
import com.espertech.esper.epl.core.SelectExprJoinWildcardProcessorObjectArray;
import com.espertech.esper.epl.core.SelectExprProcessor;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.CreateSchemaDesc;
import com.espertech.esper.epl.spec.InsertIntoDesc;
import com.espertech.esper.event.EventAdapterException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.arr.ObjectArrayEventType;
import com.espertech.esper.util.CollectionUtil;
import com.espertech.esper.util.EventRepresentationUtil;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.LinkedHashMap;

public class SelectExprJoinWildcardProcessorFactory {
    public static SelectExprProcessor create(Collection<Integer> assignedTypeNumberStack, String statementId, String[] streamNames, EventType[] streamTypes, EventAdapterService eventAdapterService, InsertIntoDesc insertIntoDesc, SelectExprEventTypeRegistry selectExprEventTypeRegistry, MethodResolutionService methodResolutionService, Annotation[] annotations, ConfigurationInformation configuration) throws ExprValidationException {
        EventType resultEventType;
        if (streamNames.length < 2 || streamTypes.length < 2 || streamNames.length != streamTypes.length) {
            throw new IllegalArgumentException("Stream names and types parameter length is invalid, expected use of this class is for join statements");
        }
        LinkedHashMap<String, Object> eventTypeMap = new LinkedHashMap<String, Object>();
        for (int i = 0; i < streamTypes.length; ++i) {
            eventTypeMap.put(streamNames[i], streamTypes[i]);
        }
        boolean useMap = EventRepresentationUtil.isMap(annotations, configuration, CreateSchemaDesc.AssignedType.NONE);
        if (insertIntoDesc != null) {
            EventType existingType = eventAdapterService.getExistsTypeByName(insertIntoDesc.getEventTypeName());
            SelectExprProcessor processor = null;
            if (existingType != null) {
                processor = SelectExprInsertEventBeanFactory.getInsertUnderlyingJoinWildcard(eventAdapterService, existingType, streamNames, streamTypes, methodResolutionService.getEngineImportService());
            }
            if (processor != null) {
                return processor;
            }
            try {
                resultEventType = useMap ? eventAdapterService.addNestableMapType(insertIntoDesc.getEventTypeName(), eventTypeMap, null, false, false, false, false, true) : eventAdapterService.addNestableObjectArrayType(insertIntoDesc.getEventTypeName(), eventTypeMap, null, false, false, false, false, true);
                selectExprEventTypeRegistry.add(resultEventType);
            }
            catch (EventAdapterException ex) {
                throw new ExprValidationException(ex.getMessage());
            }
        } else {
            resultEventType = useMap ? eventAdapterService.createAnonymousMapType(statementId + "_join_" + CollectionUtil.toString(assignedTypeNumberStack, "_"), eventTypeMap) : eventAdapterService.createAnonymousObjectArrayType(statementId + "_join_" + CollectionUtil.toString(assignedTypeNumberStack, "_"), eventTypeMap);
        }
        if (resultEventType instanceof ObjectArrayEventType) {
            return new SelectExprJoinWildcardProcessorObjectArray(streamNames, resultEventType, eventAdapterService);
        }
        return new SelectExprJoinWildcardProcessorMap(streamNames, resultEventType, eventAdapterService);
    }
}

