/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.service.StatementResultService;
import com.espertech.esper.epl.core.BindProcessor;
import com.espertech.esper.epl.core.SelectExprProcessor;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.event.NaturalEventBean;

public class SelectExprResultProcessor
implements SelectExprProcessor {
    private final StatementResultService statementResultService;
    private final SelectExprProcessor syntheticProcessor;
    private final BindProcessor bindProcessor;

    public SelectExprResultProcessor(StatementResultService statementResultService, SelectExprProcessor syntheticProcessor, BindProcessor bindProcessor) {
        this.statementResultService = statementResultService;
        this.syntheticProcessor = syntheticProcessor;
        this.bindProcessor = bindProcessor;
    }

    @Override
    public EventType getResultEventType() {
        return this.syntheticProcessor.getResultEventType();
    }

    @Override
    public EventBean process(EventBean[] eventsPerStream, boolean isNewData, boolean isSynthesize, ExprEvaluatorContext exprEvaluatorContext) {
        if (isSynthesize && !this.statementResultService.isMakeNatural()) {
            return this.syntheticProcessor.process(eventsPerStream, isNewData, isSynthesize, exprEvaluatorContext);
        }
        EventBean syntheticEvent = null;
        EventType syntheticEventType = null;
        if (this.statementResultService.isMakeSynthetic() || isSynthesize) {
            syntheticEvent = this.syntheticProcessor.process(eventsPerStream, isNewData, isSynthesize, exprEvaluatorContext);
            if (!this.statementResultService.isMakeNatural()) {
                return syntheticEvent;
            }
            syntheticEventType = this.syntheticProcessor.getResultEventType();
        }
        if (!this.statementResultService.isMakeNatural()) {
            return null;
        }
        Object[] parameters = this.bindProcessor.process(eventsPerStream, isNewData, exprEvaluatorContext);
        return new NaturalEventBean(syntheticEventType, parameters, syntheticEvent);
    }
}

