/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core.eval;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.core.SelectExprProcessor;
import com.espertech.esper.epl.core.eval.EvalSelectStreamBase;
import com.espertech.esper.epl.core.eval.SelectExprContext;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.spec.SelectClauseStreamCompiledSpec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class EvalSelectStreamBaseMap
extends EvalSelectStreamBase
implements SelectExprProcessor {
    private static final Log log = LogFactory.getLog(EvalSelectStreamBaseMap.class);

    protected EvalSelectStreamBaseMap(SelectExprContext selectExprContext, EventType resultEventType, List<SelectClauseStreamCompiledSpec> namedStreams, boolean usingWildcard) {
        super(selectExprContext, resultEventType, namedStreams, usingWildcard);
    }

    public abstract EventBean processSpecific(Map<String, Object> var1, EventBean[] var2, ExprEvaluatorContext var3);

    @Override
    public EventBean process(EventBean[] eventsPerStream, boolean isNewData, boolean isSynthesize, ExprEvaluatorContext exprEvaluatorContext) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        int count = 0;
        for (ExprEvaluator expressionNode : this.selectExprContext.getExpressionNodes()) {
            Object evalResult = expressionNode.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            props.put(this.selectExprContext.getColumnNames()[count], evalResult);
            ++count;
        }
        for (SelectClauseStreamCompiledSpec element : this.namedStreams) {
            EventBean theEvent = eventsPerStream[element.getStreamNumber()];
            props.put(this.selectExprContext.getColumnNames()[count], theEvent);
            ++count;
        }
        if (this.isUsingWildcard && eventsPerStream.length > 1) {
            for (EventBean anEventsPerStream : eventsPerStream) {
                props.put(this.selectExprContext.getColumnNames()[count], anEventsPerStream);
                ++count;
            }
        }
        return this.processSpecific(props, eventsPerStream, exprEvaluatorContext);
    }
}

