/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.datetime.calop;

import java.io.StringWriter;

public enum CalendarFieldEnum {
    MILLISEC(14, "msec,millisecond,milliseconds"),
    SECOND(13, "sec,second,seconds"),
    MINUTE(12, "min,minute,minutes"),
    HOUR(11, "hour,hours"),
    DAY(5, "day,days"),
    MONTH(2, "month,months"),
    WEEK(3, "week,weeks"),
    YEAR(1, "year,years");

    private final int calendarField;
    private final String[] names;

    private CalendarFieldEnum(int calendarField, String names) {
        this.calendarField = calendarField;
        this.names = names.split(",");
    }

    public static String getValidList() {
        StringWriter writer = new StringWriter();
        String delimiter = "";
        for (CalendarFieldEnum v : CalendarFieldEnum.values()) {
            for (String name : v.names) {
                writer.append(delimiter);
                writer.append(name);
                delimiter = ",";
            }
        }
        return writer.toString();
    }

    public int getCalendarField() {
        return this.calendarField;
    }

    public String[] getNames() {
        return this.names;
    }

    public static CalendarFieldEnum fromString(String field) {
        String compareTo = field.trim().toLowerCase();
        for (CalendarFieldEnum v : CalendarFieldEnum.values()) {
            for (String name : v.names) {
                if (!name.equals(compareTo)) continue;
                return v;
            }
        }
        return null;
    }
}

