/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.datetime.calop;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.datetime.calop.CalendarOp;
import com.espertech.esper.epl.datetime.eval.TimePeriod;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import java.util.Calendar;

public class CalendarOpPlusMinus
implements CalendarOp {
    private final ExprEvaluator param;
    private final int factor;

    public CalendarOpPlusMinus(ExprEvaluator param, int factor) {
        this.param = param;
        this.factor = factor;
    }

    @Override
    public void evaluate(Calendar cal, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        Object value = this.param.evaluate(eventsPerStream, isNewData, context);
        if (value instanceof Number) {
            CalendarOpPlusMinus.action(cal, this.factor, ((Number)value).longValue());
        } else {
            CalendarOpPlusMinus.action(cal, this.factor, (TimePeriod)value);
        }
    }

    protected static void action(Calendar cal, int factor, Long duration) {
        if (duration == null) {
            return;
        }
        long dur = duration;
        if (duration < Integer.MAX_VALUE) {
            cal.add(14, (int)((long)factor * dur));
            return;
        }
        int days = (int)(duration / 86400000L);
        int msec = (int)(duration - (long)days * 86400000L);
        cal.add(14, factor * msec);
        cal.add(5, factor * days);
    }

    protected static void action(Calendar cal, int factor, TimePeriod tp) {
        if (tp == null) {
            return;
        }
        if (tp.getYears() != null) {
            cal.add(1, factor * tp.getYears());
        }
        if (tp.getMonths() != null) {
            cal.add(2, factor * tp.getMonths());
        }
        if (tp.getWeeks() != null) {
            cal.add(3, factor * tp.getWeeks());
        }
        if (tp.getDays() != null) {
            cal.add(5, factor * tp.getDays());
        }
        if (tp.getHours() != null) {
            cal.add(11, factor * tp.getHours());
        }
        if (tp.getMinutes() != null) {
            cal.add(12, factor * tp.getMinutes());
        }
        if (tp.getSeconds() != null) {
            cal.add(13, factor * tp.getSeconds());
        }
        if (tp.getMilliseconds() != null) {
            cal.add(14, factor * tp.getMilliseconds());
        }
    }
}

