/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.datetime.calop;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.datetime.calop.ApacheCommonsDateUtils;
import com.espertech.esper.epl.datetime.calop.CalendarFieldEnum;
import com.espertech.esper.epl.datetime.calop.CalendarOp;
import com.espertech.esper.epl.datetime.eval.DatetimeMethodEnum;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import java.util.Calendar;

public class CalendarOpRound
implements CalendarOp {
    private final CalendarFieldEnum fieldName;
    private final int code;

    public CalendarOpRound(CalendarFieldEnum fieldName, DatetimeMethodEnum method) {
        this.fieldName = fieldName;
        if (method == DatetimeMethodEnum.ROUNDCEILING) {
            this.code = 2;
        } else if (method == DatetimeMethodEnum.ROUNDFLOOR) {
            this.code = 0;
        } else if (method == DatetimeMethodEnum.ROUNDHALF) {
            this.code = 1;
        } else {
            throw new IllegalArgumentException("Unrecognized method '" + (Object)((Object)method) + "'");
        }
    }

    @Override
    public void evaluate(Calendar cal, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        ApacheCommonsDateUtils.modify(cal, this.fieldName.getCalendarField(), this.code);
    }
}

