/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.db;

import com.espertech.esper.epl.db.DataCache;
import com.espertech.esper.epl.db.DataCacheUtil;
import com.espertech.esper.epl.join.table.EventTable;
import java.util.LinkedHashMap;
import java.util.Map;

public class DataCacheLRUImpl
implements DataCache {
    private final int cacheSize;
    private static final float hashTableLoadFactor = 0.75f;
    private final LinkedHashMap<Object, EventTable> cache;

    public DataCacheLRUImpl(int cacheSize) {
        this.cacheSize = cacheSize;
        int hashTableCapacity = (int)Math.ceil((float)cacheSize / 0.75f) + 1;
        this.cache = new LinkedHashMap<Object, EventTable>(hashTableCapacity, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<Object, EventTable> eldest) {
                return this.size() > DataCacheLRUImpl.this.cacheSize;
            }
        };
    }

    @Override
    public EventTable getCached(Object[] lookupKeys) {
        Object key = DataCacheUtil.getLookupKey(lookupKeys);
        return this.cache.get(key);
    }

    @Override
    public synchronized void put(Object[] keys, EventTable value) {
        Object key = DataCacheUtil.getLookupKey(keys);
        this.cache.put(key, value);
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    @Override
    public boolean isActive() {
        return true;
    }
}

