/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.db;

import com.espertech.esper.client.ConfigurationDBRef;
import com.espertech.esper.epl.db.DatabaseConfigException;
import com.espertech.esper.epl.db.DatabaseConnectionFactory;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class DatabaseDMConnFactory
implements DatabaseConnectionFactory {
    private final ConfigurationDBRef.DriverManagerConnection driverConfig;
    private final ConfigurationDBRef.ConnectionSettings connectionSettings;

    public DatabaseDMConnFactory(ConfigurationDBRef.DriverManagerConnection driverConfig, ConfigurationDBRef.ConnectionSettings connectionSettings) throws DatabaseConfigException {
        this.driverConfig = driverConfig;
        this.connectionSettings = connectionSettings;
        String driverClassName = driverConfig.getClassName();
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class.forName(driverClassName, true, cl);
        }
        catch (ClassNotFoundException ex) {
            throw new DatabaseConfigException("Error loading driver class '" + driverClassName + '\'', ex);
        }
        catch (RuntimeException ex) {
            throw new DatabaseConfigException("Error loading driver class '" + driverClassName + '\'', ex);
        }
    }

    @Override
    public Connection getConnection() throws DatabaseConfigException {
        Connection connection;
        String url = this.driverConfig.getUrl();
        Properties properties = this.driverConfig.getOptionalProperties();
        if (properties == null) {
            properties = new Properties();
        }
        try {
            String user = this.driverConfig.getOptionalUserName();
            String pwd = this.driverConfig.getOptionalPassword();
            connection = user == null && pwd == null && properties.isEmpty() ? DriverManager.getConnection(url) : (!properties.isEmpty() ? DriverManager.getConnection(url, properties) : DriverManager.getConnection(url, user, pwd));
        }
        catch (SQLException ex) {
            String detail = "SQLException: " + ex.getMessage() + " SQLState: " + ex.getSQLState() + " VendorError: " + ex.getErrorCode();
            throw new DatabaseConfigException("Error obtaining database connection using url '" + url + "' with detail " + detail, ex);
        }
        DatabaseDMConnFactory.setConnectionOptions(connection, this.connectionSettings);
        return connection;
    }

    protected static void setConnectionOptions(Connection connection, ConfigurationDBRef.ConnectionSettings connectionSettings) throws DatabaseConfigException {
        try {
            if (connectionSettings.getReadOnly() != null) {
                connection.setReadOnly(connectionSettings.getReadOnly());
            }
        }
        catch (SQLException ex) {
            throw new DatabaseConfigException("Error setting read-only to " + connectionSettings.getReadOnly() + " on connection with detail " + DatabaseDMConnFactory.getDetail(ex), ex);
        }
        try {
            if (connectionSettings.getTransactionIsolation() != null) {
                connection.setTransactionIsolation(connectionSettings.getTransactionIsolation());
            }
        }
        catch (SQLException ex) {
            throw new DatabaseConfigException("Error setting transaction isolation level to " + connectionSettings.getTransactionIsolation() + " on connection with detail " + DatabaseDMConnFactory.getDetail(ex), ex);
        }
        try {
            if (connectionSettings.getCatalog() != null) {
                connection.setCatalog(connectionSettings.getCatalog());
            }
        }
        catch (SQLException ex) {
            throw new DatabaseConfigException("Error setting catalog to '" + connectionSettings.getCatalog() + "' on connection with detail " + DatabaseDMConnFactory.getDetail(ex), ex);
        }
        try {
            if (connectionSettings.getAutoCommit() != null) {
                connection.setCatalog(connectionSettings.getCatalog());
            }
        }
        catch (SQLException ex) {
            throw new DatabaseConfigException("Error setting auto-commit to " + connectionSettings.getAutoCommit() + " on connection with detail " + DatabaseDMConnFactory.getDetail(ex), ex);
        }
    }

    private static String getDetail(SQLException ex) {
        return "SQLException: " + ex.getMessage() + " SQLState: " + ex.getSQLState() + " VendorError: " + ex.getErrorCode();
    }
}

