/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.declexpr;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.client.annotation.Audit;
import com.espertech.esper.client.annotation.AuditEnum;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.StreamTypeServiceImpl;
import com.espertech.esper.epl.declexpr.ExprDeclaredEvalBase;
import com.espertech.esper.epl.declexpr.ExprDeclaredEvalConstant;
import com.espertech.esper.epl.declexpr.ExprDeclaredEvalNoRewrite;
import com.espertech.esper.epl.declexpr.ExprDeclaredEvalRewrite;
import com.espertech.esper.epl.declexpr.ExprDeclaredNode;
import com.espertech.esper.epl.enummethod.dot.ExprDeclaredOrLambdaNode;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorProxy;
import com.espertech.esper.epl.expression.ExprFilterOptimizableNode;
import com.espertech.esper.epl.expression.ExprIdentNode;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeBase;
import com.espertech.esper.epl.expression.ExprNodeSummaryVisitor;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprNodeVisitor;
import com.espertech.esper.epl.expression.ExprNodeVisitorWithParent;
import com.espertech.esper.epl.expression.ExprNumberSetWildcard;
import com.espertech.esper.epl.expression.ExprStreamUnderlyingNode;
import com.espertech.esper.epl.expression.ExprSubselectNode;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.ExpressionDeclItem;
import com.espertech.esper.filter.FilterSpecLookupable;
import com.espertech.esper.util.SerializableObjectCopier;
import java.util.ArrayList;
import java.util.List;

public class ExprDeclaredNodeImpl
extends ExprNodeBase
implements ExprDeclaredNode,
ExprDeclaredOrLambdaNode,
ExprFilterOptimizableNode {
    private static final long serialVersionUID = 9140100131374697808L;
    private final ExpressionDeclItem prototype;
    private List<ExprNode> chainParameters;
    private transient ExprEvaluator exprEvaluator;
    private ExprNode expressionBodyCopy;

    public ExprDeclaredNodeImpl(ExpressionDeclItem prototype, List<ExprNode> chainParameters) {
        this.prototype = prototype;
        this.chainParameters = chainParameters;
        try {
            this.expressionBodyCopy = (ExprNode)SerializableObjectCopier.copy(prototype.getInner());
        }
        catch (Exception e) {
            throw new RuntimeException("Internal error providing expression tree: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean validated() {
        return this.exprEvaluator != null;
    }

    @Override
    public void setSubselectOuterStreamNames(String[] outerStreamNames, EventType[] outerEventTypesSelect, String[] outerEventTypeNames, String engineURI, ExprSubselectNode subselect, String subexpressionStreamName, EventType subselectStreamType, String subselecteventTypeName) throws ExprValidationException {
        this.checkParameterCount();
        int[] streamParameters = new int[this.chainParameters.size()];
        for (int param = 0; param < this.chainParameters.size(); ++param) {
            if (!(this.chainParameters.get(param) instanceof ExprIdentNode)) {
                throw new ExprValidationException("Sub-selects in an expression declaration require passing only stream names as parameters");
            }
            String parameterName = ((ExprIdentNode)this.chainParameters.get(param)).getUnresolvedPropertyName();
            int streamId = -1;
            for (int i = 0; i < outerStreamNames.length; ++i) {
                if (!parameterName.equals(outerStreamNames[i])) continue;
                streamId = i;
                break;
            }
            if (streamId == -1) {
                throw new ExprValidationException("Invalid parameter to expression declaration, parameter " + param + " is not the name of a stream in the query");
            }
            streamParameters[param] = streamId;
        }
        EventType[] eventTypes = new EventType[this.chainParameters.size() + 1];
        String[] streamNames = new String[this.chainParameters.size() + 1];
        eventTypes[0] = subselectStreamType;
        streamNames[0] = subexpressionStreamName;
        for (int i = 0; i < streamParameters.length; ++i) {
            eventTypes[i + 1] = outerEventTypesSelect[streamParameters[i]];
            streamNames[i + 1] = this.prototype.getParametersNames().get(i);
        }
        StreamTypeServiceImpl availableTypes = new StreamTypeServiceImpl(eventTypes, streamNames, new boolean[eventTypes.length], engineURI, false);
        availableTypes.setRequireStreamNames(true);
        subselect.setFilterSubqueryStreamTypes(availableTypes);
    }

    @Override
    public void validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.exprEvaluator != null) {
            return;
        }
        if (this.getChildNodes().length > 0) {
            throw new IllegalStateException("Execution node has its own child nodes");
        }
        ArrayList<ExprNode> validated = new ArrayList<ExprNode>();
        for (ExprNode expr : this.chainParameters) {
            validated.add(ExprNodeUtility.getValidatedSubtree(expr, validationContext));
        }
        this.chainParameters = validated;
        this.checkParameterCount();
        EventType[] eventTypes = new EventType[this.prototype.getParametersNames().size()];
        String[] streamNames = new String[this.prototype.getParametersNames().size()];
        boolean[] isIStreamOnly = new boolean[this.prototype.getParametersNames().size()];
        int[] streamsIdsPerStream = new int[this.prototype.getParametersNames().size()];
        boolean allStreamIdsMatch = true;
        for (int i = 0; i < this.prototype.getParametersNames().size(); ++i) {
            ExprNode parameter = this.chainParameters.get(i);
            streamNames[i] = this.prototype.getParametersNames().get(i);
            if (parameter instanceof ExprStreamUnderlyingNode) {
                ExprStreamUnderlyingNode und = (ExprStreamUnderlyingNode)parameter;
                eventTypes[i] = validationContext.getStreamTypeService().getEventTypes()[und.getStreamId()];
                isIStreamOnly[i] = validationContext.getStreamTypeService().getIStreamOnly()[und.getStreamId()];
                streamsIdsPerStream[i] = und.getStreamId();
            } else if (parameter instanceof ExprNumberSetWildcard) {
                if (validationContext.getStreamTypeService().getEventTypes().length != 1) {
                    throw new ExprValidationException("Expression '" + this.prototype.getName() + "' only allows a wildcard parameter if there is a single stream available, please use a stream or tag name instead");
                }
                eventTypes[i] = validationContext.getStreamTypeService().getEventTypes()[0];
                isIStreamOnly[i] = validationContext.getStreamTypeService().getIStreamOnly()[0];
                streamsIdsPerStream[i] = 0;
            } else {
                throw new ExprValidationException("Expression '" + this.prototype.getName() + "' requires a stream name as a parameter");
            }
            if (streamsIdsPerStream[i] == i) continue;
            allStreamIdsMatch = false;
        }
        StreamTypeService streamTypeService = validationContext.getStreamTypeService();
        StreamTypeServiceImpl copyTypes = new StreamTypeServiceImpl(eventTypes, streamNames, isIStreamOnly, streamTypeService.getEngineURIQualifier(), streamTypeService.isOnDemandStreams());
        copyTypes.setRequireStreamNames(true);
        try {
            ExprValidationContext expressionBodyContext = new ExprValidationContext(copyTypes, validationContext);
            this.expressionBodyCopy = ExprNodeUtility.getValidatedSubtree(this.expressionBodyCopy, expressionBodyContext);
        }
        catch (ExprValidationException ex) {
            String message = "Error validating expression declaration '" + this.prototype.getName() + "': " + ex.getMessage();
            throw new ExprValidationException(message, ex);
        }
        this.addChildNode(this.expressionBodyCopy);
        ExprNodeSummaryVisitor summaryVisitor = new ExprNodeSummaryVisitor();
        this.expressionBodyCopy.accept(summaryVisitor);
        boolean isCache = !summaryVisitor.isHasAggregation() && !summaryVisitor.isHasPreviousPrior();
        this.exprEvaluator = this.expressionBodyCopy.isConstantResult() ? new ExprDeclaredEvalConstant(this.expressionBodyCopy.getExprEvaluator().getType(), this.expressionBodyCopy.getExprEvaluator().evaluate(null, true, null)) : (this.prototype.getParametersNames().isEmpty() || allStreamIdsMatch && this.prototype.getParametersNames().size() == streamTypeService.getEventTypes().length ? new ExprDeclaredEvalNoRewrite(this.expressionBodyCopy.getExprEvaluator(), this.prototype, isCache) : new ExprDeclaredEvalRewrite(this.expressionBodyCopy.getExprEvaluator(), this.prototype, isCache, streamsIdsPerStream));
        Audit audit = AuditEnum.EXPRDEF.getAudit(validationContext.getAnnotations());
        if (audit != null) {
            this.exprEvaluator = (ExprEvaluator)ExprEvaluatorProxy.newInstance(validationContext.getStreamTypeService().getEngineURIQualifier(), validationContext.getStatementName(), this.prototype.getName(), this.exprEvaluator);
        }
    }

    @Override
    public boolean getFilterLookupEligible() {
        return true;
    }

    @Override
    public FilterSpecLookupable getFilterLookupable() {
        return new FilterSpecLookupable(this.toExpressionString(), new DeclaredNodeEventPropertyGetter(this.exprEvaluator), this.exprEvaluator.getType());
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprDeclaredNodeImpl)) {
            return false;
        }
        ExprDeclaredNodeImpl otherExprCaseNode = (ExprDeclaredNodeImpl)node;
        return this.expressionBodyCopy.equalsNode(otherExprCaseNode.getExpressionBodyCopy());
    }

    @Override
    public void accept(ExprNodeVisitor visitor) {
        super.accept(visitor);
        if (this.getChildNodes().length == 0) {
            this.expressionBodyCopy.accept(visitor);
        }
    }

    @Override
    public void accept(ExprNodeVisitorWithParent visitor) {
        super.accept(visitor);
        if (this.getChildNodes().length == 0) {
            this.expressionBodyCopy.accept(visitor);
        }
    }

    @Override
    public void acceptChildnodes(ExprNodeVisitorWithParent visitor, ExprNode parent) {
        super.acceptChildnodes(visitor, parent);
        if (this.getChildNodes().length == 0) {
            this.expressionBodyCopy.accept(visitor);
        }
    }

    public ExprNode getExpressionBodyCopy() {
        return this.expressionBodyCopy;
    }

    @Override
    public ExpressionDeclItem getPrototype() {
        return this.prototype;
    }

    @Override
    public List<ExprNode> getChainParameters() {
        return this.chainParameters;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this.exprEvaluator;
    }

    private void checkParameterCount() throws ExprValidationException {
        if (this.chainParameters.size() != this.prototype.getParametersNames().size()) {
            throw new ExprValidationException("Parameter count mismatches for declared expression '" + this.prototype.getName() + "', expected " + this.prototype.getParametersNames().size() + " parameters but received " + this.chainParameters.size() + " parameters");
        }
    }

    @Override
    public String toExpressionString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.prototype.getName() + "(");
        String delimiter = "";
        for (ExprNode parameter : this.chainParameters) {
            buf.append(delimiter);
            buf.append(parameter.toExpressionString());
            delimiter = ", ";
        }
        buf.append(")");
        return buf.toString();
    }

    private static final class DeclaredNodeEventPropertyGetter
    implements EventPropertyGetter {
        private final ExprEvaluator exprEvaluator;

        private DeclaredNodeEventPropertyGetter(ExprEvaluator exprEvaluator) {
            this.exprEvaluator = ((ExprDeclaredEvalBase)exprEvaluator).getInnerEvaluator();
        }

        @Override
        public Object get(EventBean eventBean) throws PropertyAccessException {
            EventBean[] events = new EventBean[]{eventBean};
            return this.exprEvaluator.evaluate(events, true, null);
        }

        @Override
        public boolean isExistsProperty(EventBean eventBean) {
            return false;
        }

        @Override
        public Object getFragment(EventBean eventBean) throws PropertyAccessException {
            return null;
        }
    }
}

