/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.enummethod.dot;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.util.ExpressionReturnType;
import com.espertech.esper.epl.enummethod.dot.ExprDotStaticMethodWrap;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.bean.BeanEventType;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ExprDotStaticMethodWrapArrayEvents
implements ExprDotStaticMethodWrap {
    private EventAdapterService eventAdapterService;
    private BeanEventType type;

    public ExprDotStaticMethodWrapArrayEvents(EventAdapterService eventAdapterService, BeanEventType type) {
        this.eventAdapterService = eventAdapterService;
        this.type = type;
    }

    @Override
    public ExpressionReturnType getTypeInfo() {
        return ExpressionReturnType.collectionOfEvents(this.type);
    }

    @Override
    public Collection convert(Object result) {
        if (result == null) {
            return null;
        }
        if (!result.getClass().isArray()) {
            return null;
        }
        return new WrappingCollection(this.eventAdapterService, this.type, result);
    }

    public static class WrappingIterator
    implements Iterator<EventBean> {
        private EventAdapterService eventAdapterService;
        private BeanEventType type;
        private Object array;
        private int count;

        public WrappingIterator(EventAdapterService eventAdapterService, BeanEventType type, Object array) {
            this.eventAdapterService = eventAdapterService;
            this.type = type;
            this.array = array;
        }

        @Override
        public boolean hasNext() {
            return Array.getLength(this.array) > this.count;
        }

        @Override
        public EventBean next() {
            Object next;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if ((next = Array.get(this.array, this.count++)) == null) {
                return null;
            }
            return this.eventAdapterService.adapterForTypedBean(next, this.type);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class WrappingCollection
    implements Collection<EventBean> {
        private EventAdapterService eventAdapterService;
        private BeanEventType type;
        private Object array;

        private WrappingCollection(EventAdapterService eventAdapterService, BeanEventType type, Object array) {
            this.eventAdapterService = eventAdapterService;
            this.type = type;
            this.array = array;
        }

        @Override
        public int size() {
            return Array.getLength(this.array);
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public Iterator<EventBean> iterator() {
            return new WrappingIterator(this.eventAdapterService, this.type, this.array);
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException("Partial implementation");
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException("Partial implementation");
        }

        @Override
        public <T> T[] toArray(T[] a) {
            throw new UnsupportedOperationException("Partial implementation");
        }

        @Override
        public boolean add(EventBean eventBean) {
            throw new UnsupportedOperationException("Read-only implementation");
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException("Read-only implementation");
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new UnsupportedOperationException("Read-only implementation");
        }

        @Override
        public boolean addAll(Collection<? extends EventBean> c) {
            throw new UnsupportedOperationException("Read-only implementation");
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException("Read-only implementation");
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException("Read-only implementation");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Read-only implementation");
        }
    }
}

