/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.enummethod.dot;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.service.ExpressionResultCacheEntry;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprEvaluatorEnumeration;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.event.EventAdapterService;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class PropertyExprEvaluatorEventCollection
implements ExprEvaluatorEnumeration {
    private final String propertyNameCache;
    private final int streamId;
    private final EventType fragmentType;
    private final EventPropertyGetter getter;

    public PropertyExprEvaluatorEventCollection(String propertyName, int streamId, EventType fragmentType, EventPropertyGetter getter) {
        this.streamId = streamId;
        this.propertyNameCache = Integer.toString(streamId) + "_" + propertyName;
        this.fragmentType = fragmentType;
        this.getter = getter;
    }

    @Override
    public Collection<EventBean> evaluateGetROCollectionEvents(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        EventBean eventInQuestion = eventsPerStream[this.streamId];
        ExpressionResultCacheEntry<EventBean, Collection<EventBean>> cacheEntry = context.getExpressionResultCacheService().getPropertyColl(this.propertyNameCache, eventInQuestion);
        if (cacheEntry != null) {
            return cacheEntry.getResult();
        }
        EventBean[] events = (EventBean[])this.getter.getFragment(eventInQuestion);
        List<EventBean> coll = events == null ? null : Arrays.asList(events);
        context.getExpressionResultCacheService().savePropertyColl(this.propertyNameCache, eventInQuestion, coll);
        if (coll == null) {
            return null;
        }
        return coll;
    }

    @Override
    public Collection evaluateGetROCollectionScalar(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return null;
    }

    @Override
    public EventType getEventTypeCollection(EventAdapterService eventAdapterService) {
        return this.fragmentType;
    }

    @Override
    public Class getComponentTypeCollection() throws ExprValidationException {
        return null;
    }

    @Override
    public EventType getEventTypeSingle(EventAdapterService eventAdapterService, String statementId) throws ExprValidationException {
        return null;
    }

    @Override
    public EventBean evaluateGetEventBean(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return null;
    }
}

