/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.enummethod.eval;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.enummethod.eval.EnumEval;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprEvaluatorEnumeration;
import java.util.ArrayList;
import java.util.Collection;

public class EnumEvalExcept
implements EnumEval {
    private final int numStreams;
    private final ExprEvaluatorEnumeration evaluator;
    private final boolean scalar;

    public EnumEvalExcept(int numStreams, ExprEvaluatorEnumeration evaluator, boolean scalar) {
        this.numStreams = numStreams;
        this.evaluator = evaluator;
        this.scalar = scalar;
    }

    @Override
    public int getStreamNumSize() {
        return this.numStreams;
    }

    @Override
    public Object evaluateEnumMethod(EventBean[] eventsLambda, Collection target, boolean isNewData, ExprEvaluatorContext context) {
        if (target == null) {
            return null;
        }
        Collection<EventBean> set = this.scalar ? this.evaluator.evaluateGetROCollectionScalar(eventsLambda, isNewData, context) : this.evaluator.evaluateGetROCollectionEvents(eventsLambda, isNewData, context);
        if (set == null || set.isEmpty() || target.isEmpty()) {
            return target;
        }
        if (this.scalar) {
            ArrayList result = new ArrayList(target);
            result.removeAll(set);
            return result;
        }
        Collection targetEvents = target;
        Collection<EventBean> sourceEvents = set;
        ArrayList<EventBean> result = new ArrayList<EventBean>();
        for (EventBean targetEvent : targetEvents) {
            if (targetEvent == null) {
                result.add(null);
                continue;
            }
            boolean found = false;
            for (EventBean sourceEvent : sourceEvents) {
                if (targetEvent == sourceEvent) {
                    found = true;
                    break;
                }
                if (sourceEvent == null || !targetEvent.getUnderlying().equals(sourceEvent.getUnderlying())) continue;
                found = true;
                break;
            }
            if (found) continue;
            result.add(targetEvent);
        }
        return result;
    }
}

