/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.epl.agg.access.AggregationAccessor;
import com.espertech.esper.epl.agg.access.AggregationAccessorAll;
import com.espertech.esper.epl.agg.access.AggregationAccessorFirst;
import com.espertech.esper.epl.agg.access.AggregationAccessorFirstLastIndex;
import com.espertech.esper.epl.agg.access.AggregationAccessorLast;
import com.espertech.esper.epl.agg.access.AggregationState;
import com.espertech.esper.epl.agg.access.AggregationStateKey;
import com.espertech.esper.epl.agg.access.AggregationStateType;
import com.espertech.esper.epl.agg.aggregator.AggregationMethod;
import com.espertech.esper.epl.agg.service.AggregationMethodFactory;
import com.espertech.esper.epl.agg.service.AggregationStateFactory;
import com.espertech.esper.epl.agg.service.AggregationStateKeyWStream;
import com.espertech.esper.epl.agg.service.AggregationStateTypeWStream;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.util.JavaClassHelper;

public class ExprAggMultiFunctionLinearAccessNodeFactory
implements AggregationMethodFactory {
    private static final ExprNode[] NO_CRITERIA_EXPR = new ExprNode[0];
    private final AggregationStateType stateType;
    private final Class resultType;
    private final int streamNum;
    private final ExprEvaluator childNode;
    private final ExprNode indexEvalNode;
    private final boolean istreamOnly;
    private final boolean ondemandQuery;

    public ExprAggMultiFunctionLinearAccessNodeFactory(AggregationStateType stateType, Class resultType, int streamNum, ExprEvaluator childNode, ExprNode indexEvalNode, boolean istreamOnly, boolean ondemandQuery) {
        this.stateType = stateType;
        this.resultType = resultType;
        this.streamNum = streamNum;
        this.childNode = childNode;
        this.indexEvalNode = indexEvalNode;
        this.istreamOnly = istreamOnly;
        this.ondemandQuery = ondemandQuery;
    }

    @Override
    public Class getResultType() {
        if (this.stateType == AggregationStateType.WINDOW) {
            return JavaClassHelper.getArrayType(this.resultType);
        }
        return this.resultType;
    }

    @Override
    public AggregationStateKey getAggregationStateKey(boolean isMatchRecognize) {
        return new AggregationStateKeyWStream(this.streamNum, AggregationStateTypeWStream.DATAWINDOWACCESS_LINEAR, NO_CRITERIA_EXPR);
    }

    @Override
    public boolean isAccessAggregation() {
        if (this.ondemandQuery && this.stateType == AggregationStateType.WINDOW) {
            return true;
        }
        return !this.istreamOnly && !this.ondemandQuery;
    }

    @Override
    public AggregationStateFactory getAggregationStateFactory(boolean isMatchRecognize) {
        if (isMatchRecognize) {
            return null;
        }
        return new AggregationStateFactory(){

            @Override
            public AggregationState createAccess(MethodResolutionService methodResolutionService, int agentInstanceId, int groupId, int aggregationId, boolean join, Object groupKey) {
                if (join) {
                    return methodResolutionService.makeAccessAggLinearJoin(agentInstanceId, groupId, aggregationId, ExprAggMultiFunctionLinearAccessNodeFactory.this.streamNum);
                }
                return methodResolutionService.makeAccessAggLinearNonJoin(agentInstanceId, groupId, aggregationId, ExprAggMultiFunctionLinearAccessNodeFactory.this.streamNum);
            }
        };
    }

    @Override
    public AggregationAccessor getAccessor() {
        if (this.indexEvalNode != null) {
            boolean isFirst = this.stateType == AggregationStateType.FIRST;
            int constant = -1;
            if (this.indexEvalNode.isConstantResult()) {
                constant = (Integer)this.indexEvalNode.getExprEvaluator().evaluate(null, true, null);
            }
            return new AggregationAccessorFirstLastIndex(this.streamNum, this.childNode, this.indexEvalNode.getExprEvaluator(), constant, isFirst);
        }
        if (this.stateType == AggregationStateType.FIRST) {
            return new AggregationAccessorFirst(this.streamNum, this.childNode);
        }
        if (this.stateType == AggregationStateType.LAST) {
            return new AggregationAccessorLast(this.streamNum, this.childNode);
        }
        if (this.stateType == AggregationStateType.WINDOW) {
            return new AggregationAccessorAll(this.streamNum, this.childNode, this.resultType);
        }
        throw new IllegalStateException("Access type is undefined or not known as code '" + (Object)((Object)this.stateType) + "'");
    }

    @Override
    public AggregationMethod make(MethodResolutionService methodResolutionService, int agentInstanceId, int groupId, int aggregationId) {
        if (this.stateType == AggregationStateType.FIRST) {
            return methodResolutionService.makeFirstEverValueAggregator(agentInstanceId, groupId, aggregationId, this.resultType, false);
        }
        if (this.stateType == AggregationStateType.LAST) {
            return methodResolutionService.makeLastEverValueAggregator(agentInstanceId, groupId, aggregationId, this.resultType, false);
        }
        throw new RuntimeException("Window aggregation function is not available");
    }

    public AggregationMethodFactory getPrototypeAggregator() {
        return this;
    }
}

