/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.agg.service.AggregationMethodFactory;
import com.espertech.esper.epl.expression.ExprAggMultiFunctionLinearAccessNode;
import com.espertech.esper.epl.expression.ExprAggMultiFunctionSortedMinMaxByNodeFactory;
import com.espertech.esper.epl.expression.ExprAggregateNode;
import com.espertech.esper.epl.expression.ExprAggregateNodeBase;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprEvaluatorEnumeration;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprOrderedExpr;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.event.EventAdapterService;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Set;

public class ExprAggMultiFunctionSortedMinMaxByNode
extends ExprAggregateNodeBase
implements ExprEvaluatorEnumeration {
    private static final long serialVersionUID = -8407756454712340265L;
    private final boolean max;
    private final boolean ever;
    private final boolean sortedwin;
    private transient EventType containedType;

    public ExprAggMultiFunctionSortedMinMaxByNode(boolean max, boolean ever, boolean sortedwin) {
        super(false);
        this.max = max;
        this.ever = ever;
        this.sortedwin = sortedwin;
    }

    @Override
    public AggregationMethodFactory validateAggregationChild(ExprValidationContext validationContext) throws ExprValidationException {
        Set<Integer> streams = ExprNodeUtility.getIdentStreamNumbers(this.getChildNodes()[0]);
        if (streams.size() > 1) {
            throw new ExprValidationException(this.getErrorPrefix() + " requires that any parameter expressions evaluate properties of the same stream");
        }
        int streamNum = streams.iterator().next();
        boolean forceEver = false;
        if (!this.ever && ExprAggMultiFunctionLinearAccessNode.getIstreamOnly(validationContext.getStreamTypeService(), streamNum)) {
            if (this.sortedwin) {
                throw new ExprValidationException(this.getErrorPrefix() + " requires that a data window is declared for the stream");
            }
            forceEver = true;
        }
        this.containedType = validationContext.getStreamTypeService().getEventTypes()[streamNum];
        Class resultType = validationContext.getStreamTypeService().getEventTypes()[streamNum].getUnderlyingType();
        ExprEvaluator[] evaluators = ExprNodeUtility.getEvaluators(this.getChildNodes());
        ExprNode[] criteriaExpressions = new ExprNode[this.getChildNodes().length];
        boolean[] sortDescending = new boolean[this.getChildNodes().length];
        for (int i = 0; i < this.getChildNodes().length; ++i) {
            ExprNode parameter;
            criteriaExpressions[i] = parameter = this.getChildNodes()[i];
            if (!(parameter instanceof ExprOrderedExpr)) continue;
            ExprOrderedExpr ordered = (ExprOrderedExpr)parameter;
            sortDescending[i] = ordered.isDescending();
            if (ordered.isDescending()) continue;
            criteriaExpressions[i] = ordered.getChildNodes()[0];
        }
        return new ExprAggMultiFunctionSortedMinMaxByNodeFactory(streamNum, resultType, criteriaExpressions, validationContext.getMethodResolutionService(), sortDescending, evaluators, this.max, this.ever || forceEver, this.sortedwin);
    }

    @Override
    public String getAggregationFunctionName() {
        if (this.sortedwin) {
            return "sorted";
        }
        if (this.ever) {
            return this.max ? "maxbyever" : "minbyever";
        }
        return this.max ? "maxby" : "minby";
    }

    @Override
    public String toExpressionString() {
        StringWriter writer = new StringWriter();
        writer.append(this.getAggregationFunctionName());
        ExprNodeUtility.toExpressionStringParams(writer, this.getChildNodes(), false, null, false);
        return writer.toString();
    }

    @Override
    public Collection<EventBean> evaluateGetROCollectionEvents(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return this.aggregationResultFuture.getCollection(this.column, context);
    }

    @Override
    public Collection evaluateGetROCollectionScalar(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return null;
    }

    @Override
    public EventType getEventTypeCollection(EventAdapterService eventAdapterService) {
        if (!this.sortedwin) {
            return null;
        }
        return this.containedType;
    }

    @Override
    public Class getComponentTypeCollection() throws ExprValidationException {
        return null;
    }

    @Override
    public EventType getEventTypeSingle(EventAdapterService eventAdapterService, String statementId) throws ExprValidationException {
        if (this.sortedwin) {
            return null;
        }
        return this.containedType;
    }

    @Override
    public EventBean evaluateGetEventBean(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return this.aggregationResultFuture.getEventBean(this.column, context);
    }

    @Override
    protected boolean equalsNodeAggregate(ExprAggregateNode node) {
        if (this == node) {
            return true;
        }
        if (node == null || this.getClass() != node.getClass()) {
            return false;
        }
        ExprAggMultiFunctionSortedMinMaxByNode that = (ExprAggMultiFunctionSortedMinMaxByNode)node;
        return this.max == that.max && this.ever == that.ever && this.sortedwin == that.sortedwin;
    }

    private String getErrorPrefix() {
        return "The '" + this.getAggregationFunctionName() + "' aggregation function";
    }
}

