/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.epl.agg.access.AggregationAccessor;
import com.espertech.esper.epl.agg.access.AggregationAccessorMinMaxBy;
import com.espertech.esper.epl.agg.access.AggregationAccessorSorted;
import com.espertech.esper.epl.agg.access.AggregationState;
import com.espertech.esper.epl.agg.access.AggregationStateKey;
import com.espertech.esper.epl.agg.access.AggregationStateMinMaxByEverSpec;
import com.espertech.esper.epl.agg.access.AggregationStateSortedSpec;
import com.espertech.esper.epl.agg.aggregator.AggregationMethod;
import com.espertech.esper.epl.agg.service.AggregationMethodFactory;
import com.espertech.esper.epl.agg.service.AggregationStateFactory;
import com.espertech.esper.epl.agg.service.AggregationStateKeyWStream;
import com.espertech.esper.epl.agg.service.AggregationStateTypeWStream;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.util.CollectionUtil;
import com.espertech.esper.util.JavaClassHelper;
import java.util.Comparator;

public class ExprAggMultiFunctionSortedMinMaxByNodeFactory
implements AggregationMethodFactory {
    private final int streamNum;
    private final Class resultType;
    private final ExprNode[] criteriaExpressions;
    private final MethodResolutionService methodResolutionService;
    private final boolean[] sortDescending;
    private final ExprEvaluator[] evaluators;
    private final boolean max;
    private final boolean ever;
    private final boolean sortedwin;

    public ExprAggMultiFunctionSortedMinMaxByNodeFactory(int streamNum, Class resultType, ExprNode[] criteriaExpressions, MethodResolutionService methodResolutionService, boolean[] sortDescending, ExprEvaluator[] evaluators, boolean max, boolean ever, boolean sortedwin) {
        this.streamNum = streamNum;
        this.resultType = resultType;
        this.criteriaExpressions = criteriaExpressions;
        this.methodResolutionService = methodResolutionService;
        this.sortDescending = sortDescending;
        this.evaluators = evaluators;
        this.max = max;
        this.ever = ever;
        this.sortedwin = sortedwin;
    }

    @Override
    public boolean isAccessAggregation() {
        return true;
    }

    @Override
    public AggregationMethod make(MethodResolutionService methodResolutionService, int agentInstanceId, int groupId, int aggregationId) {
        throw new IllegalStateException("Aggregation function is not available");
    }

    @Override
    public Class getResultType() {
        if (this.sortedwin) {
            return JavaClassHelper.getArrayType(this.resultType);
        }
        return this.resultType;
    }

    @Override
    public AggregationStateKey getAggregationStateKey(boolean isMatchRecognize) {
        if (isMatchRecognize) {
            return null;
        }
        AggregationStateTypeWStream type = this.ever ? (this.max ? AggregationStateTypeWStream.MAXEVER : AggregationStateTypeWStream.MINEVER) : AggregationStateTypeWStream.SORTED;
        return new AggregationStateKeyWStream(this.streamNum, type, this.criteriaExpressions);
    }

    @Override
    public AggregationStateFactory getAggregationStateFactory(boolean isMatchRecognize) {
        AggregationStateFactory factory;
        if (isMatchRecognize) {
            return null;
        }
        boolean sortUsingCollator = this.methodResolutionService.isSortUsingCollator();
        Comparator<Object> comparator = CollectionUtil.getComparator(this.evaluators, sortUsingCollator, this.sortDescending);
        Object criteriaKeyBinding = this.methodResolutionService.getCriteriaKeyBinding(this.evaluators);
        if (this.ever) {
            final AggregationStateMinMaxByEverSpec spec = new AggregationStateMinMaxByEverSpec(this.streamNum, this.evaluators, this.max, comparator, criteriaKeyBinding);
            factory = new AggregationStateFactory(){

                @Override
                public AggregationState createAccess(MethodResolutionService methodResolutionService, int agentInstanceId, int groupId, int aggregationId, boolean join, Object groupKey) {
                    return methodResolutionService.makeAccessAggMinMaxEver(agentInstanceId, groupId, aggregationId, spec);
                }
            };
        } else {
            final AggregationStateSortedSpec spec = new AggregationStateSortedSpec(this.streamNum, this.evaluators, comparator, criteriaKeyBinding);
            factory = new AggregationStateFactory(){

                @Override
                public AggregationState createAccess(MethodResolutionService methodResolutionService, int agentInstanceId, int groupId, int aggregationId, boolean join, Object groupKey) {
                    if (join) {
                        return methodResolutionService.makeAccessAggSortedJoin(agentInstanceId, groupId, aggregationId, spec);
                    }
                    return methodResolutionService.makeAccessAggSortedNonJoin(agentInstanceId, groupId, aggregationId, spec);
                }
            };
        }
        return factory;
    }

    @Override
    public AggregationAccessor getAccessor() {
        if (!this.sortedwin) {
            return new AggregationAccessorMinMaxBy(this.max);
        }
        return new AggregationAccessorSorted(this.max, this.resultType);
    }
}

