/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeBase;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import java.util.Arrays;
import java.util.Map;

public class ExprContextPropertyNode
extends ExprNodeBase
implements ExprEvaluator {
    private static final long serialVersionUID = 2816977190089087618L;
    private final String propertyName;
    private Class returnType;
    private transient EventPropertyGetter getter;

    public ExprContextPropertyNode(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public Map<String, Object> getEventType() {
        return null;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public void validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (validationContext.getContextDescriptor() == null) {
            throw new ExprValidationException("Context property '" + this.propertyName + "' cannot be used in the expression as provided");
        }
        EventType eventType = validationContext.getContextDescriptor().getContextPropertyRegistry().getContextEventType();
        if (eventType == null) {
            throw new ExprValidationException("Context property '" + this.propertyName + "' cannot be used in the expression as provided");
        }
        this.getter = eventType.getGetter(this.propertyName);
        if (this.getter == null) {
            throw new ExprValidationException("Context property '" + this.propertyName + "' is not a known property, known properties are " + Arrays.toString(eventType.getPropertyNames()));
        }
        this.returnType = eventType.getPropertyType(this.propertyName);
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        if (context.getContextProperties() == null) {
            return null;
        }
        return this.getter.get(context.getContextProperties());
    }

    @Override
    public Class getType() {
        return this.returnType;
    }

    @Override
    public String toExpressionString() {
        return this.propertyName;
    }

    public EventPropertyGetter getGetter() {
        return this.getter;
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        if (this == node) {
            return true;
        }
        if (node == null || this.getClass() != node.getClass()) {
            return false;
        }
        ExprContextPropertyNode that = (ExprContextPropertyNode)node;
        return this.propertyName.equals(that.propertyName);
    }
}

