/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.epl.agg.service.AggregationMethodFactory;
import com.espertech.esper.epl.expression.ExprAggregateNode;
import com.espertech.esper.epl.expression.ExprAggregateNodeBase;
import com.espertech.esper.epl.expression.ExprCountNodeFactory;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;

public class ExprCountNode
extends ExprAggregateNodeBase {
    private static final long serialVersionUID = 1859320277242087598L;
    private final boolean hasFilter;

    public ExprCountNode(boolean distinct, boolean hasFilter) {
        super(distinct);
        this.hasFilter = hasFilter;
    }

    @Override
    public AggregationMethodFactory validateAggregationChild(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.getChildNodes().length > 2) {
            throw new ExprValidationException("Count node must have less then 2 child nodes");
        }
        Class childType = null;
        boolean ignoreNulls = false;
        if (this.getChildNodes().length != 0) {
            if (this.getChildNodes().length == 1) {
                if (!this.hasFilter) {
                    childType = this.getChildNodes()[0].getExprEvaluator().getType();
                    ignoreNulls = true;
                } else {
                    super.validateFilter(this.getChildNodes()[0].getExprEvaluator());
                }
            } else if (this.getChildNodes().length == 2) {
                childType = this.getChildNodes()[0].getExprEvaluator().getType();
                ignoreNulls = true;
            }
        }
        return new ExprCountNodeFactory(ignoreNulls, this.isDistinct, childType, this.hasFilter);
    }

    @Override
    protected String getAggregationFunctionName() {
        return "count";
    }

    @Override
    public final boolean equalsNodeAggregate(ExprAggregateNode node) {
        return node instanceof ExprCountNode;
    }
}

