/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.util.ExpressionReturnType;
import com.espertech.esper.epl.expression.ExprDotEval;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import java.lang.reflect.Array;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExprDotEvalArrayGet
implements ExprDotEval {
    private static final Log log = LogFactory.getLog(ExprDotEvalArrayGet.class);
    private final ExpressionReturnType typeInfo;
    private final ExprEvaluator indexExpression;

    public ExprDotEvalArrayGet(ExprEvaluator index, Class componentType) {
        this.indexExpression = index;
        this.typeInfo = ExpressionReturnType.singleValue(componentType);
    }

    @Override
    public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (target == null) {
            return null;
        }
        Object index = this.indexExpression.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (index == null) {
            return null;
        }
        if (!(index instanceof Integer)) {
            return null;
        }
        int indexNum = (Integer)index;
        if (Array.getLength(target) <= indexNum) {
            return null;
        }
        return Array.get(target, indexNum);
    }

    @Override
    public ExpressionReturnType getTypeInfo() {
        return this.typeInfo;
    }
}

