/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.epl.enummethod.dot.ExprDotStaticMethodWrap;
import com.espertech.esper.epl.expression.ExprDotEval;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.util.JavaClassHelper;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import net.sf.cglib.reflect.FastMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExprDotEvalStaticMethod
implements ExprEvaluator,
EventPropertyGetter {
    private static final Log log = LogFactory.getLog(ExprDotEvalStaticMethod.class);
    private final String statementName;
    private final String classOrPropertyName;
    private final FastMethod staticMethod;
    private final ExprEvaluator[] childEvals;
    private final boolean isConstantParameters;
    private final ExprDotEval[] chainEval;
    private final ExprDotStaticMethodWrap resultWrapLambda;
    private final boolean rethrowExceptions;
    private final Object targetObject;
    private boolean isCachedResult;
    private Object cachedResult;

    public ExprDotEvalStaticMethod(String statementName, String classOrPropertyName, FastMethod staticMethod, ExprEvaluator[] childEvals, boolean constantParameters, ExprDotStaticMethodWrap resultWrapLambda, ExprDotEval[] chainEval, boolean rethrowExceptions, Object targetObject) {
        this.statementName = statementName;
        this.classOrPropertyName = classOrPropertyName;
        this.staticMethod = staticMethod;
        this.childEvals = childEvals;
        this.targetObject = targetObject;
        this.isConstantParameters = chainEval.length > 0 ? false : constantParameters;
        this.resultWrapLambda = resultWrapLambda;
        this.chainEval = chainEval;
        this.rethrowExceptions = rethrowExceptions;
    }

    @Override
    public Class getType() {
        if (this.chainEval.length == 0) {
            return this.staticMethod.getReturnType();
        }
        return this.chainEval[this.chainEval.length - 1].getTypeInfo().getSingleValueType();
    }

    @Override
    public Map<String, Object> getEventType() {
        return null;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (this.isConstantParameters && this.isCachedResult) {
            return this.cachedResult;
        }
        Object[] args = new Object[this.childEvals.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.childEvals[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        }
        try {
            Object result = this.staticMethod.invoke(this.targetObject, args);
            if (this.resultWrapLambda != null) {
                result = this.resultWrapLambda.convert(result);
            }
            for (int i = 0; i < this.chainEval.length; ++i) {
                if ((result = this.chainEval[i].evaluate(result, eventsPerStream, isNewData, exprEvaluatorContext)) != null) continue;
                return result;
            }
            if (this.isConstantParameters) {
                this.cachedResult = result;
                this.isCachedResult = true;
            }
            return result;
        }
        catch (InvocationTargetException e) {
            String message = JavaClassHelper.getMessageInvocationTarget(this.statementName, this.staticMethod.getJavaMethod(), this.classOrPropertyName, args, e);
            log.error((Object)message, e.getTargetException());
            if (this.rethrowExceptions) {
                throw new EPException(message, e.getTargetException());
            }
            return null;
        }
    }

    @Override
    public Object get(EventBean eventBean) throws PropertyAccessException {
        Object[] args = new Object[this.childEvals.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.childEvals[i].evaluate(new EventBean[]{eventBean}, false, null);
        }
        try {
            return this.staticMethod.invoke(this.targetObject, args);
        }
        catch (InvocationTargetException e) {
            String message = JavaClassHelper.getMessageInvocationTarget(this.statementName, this.staticMethod.getJavaMethod(), this.classOrPropertyName, args, e);
            log.error((Object)message, e.getTargetException());
            if (this.rethrowExceptions) {
                throw new EPException(message, e.getTargetException());
            }
            return null;
        }
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return false;
    }

    @Override
    public Object getFragment(EventBean eventBean) throws PropertyAccessException {
        return null;
    }
}

