/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventPropertyDescriptor;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventPropertyGetterIndexed;
import com.espertech.esper.client.EventPropertyGetterMapped;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.FragmentEventType;
import com.espertech.esper.client.util.ExpressionReturnType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.core.PropertyResolutionDescriptor;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.datetime.eval.ExprDotNodeFilterAnalyzerDesc;
import com.espertech.esper.epl.enummethod.dot.EnumMethodEnum;
import com.espertech.esper.epl.enummethod.dot.ExprDotStaticMethodWrap;
import com.espertech.esper.epl.enummethod.dot.ExprDotStaticMethodWrapArrayScalar;
import com.espertech.esper.epl.enummethod.dot.ExprDotStaticMethodWrapFactory;
import com.espertech.esper.epl.enummethod.dot.PropertyExprEvaluatorEventCollection;
import com.espertech.esper.epl.enummethod.dot.PropertyExprEvaluatorNonLambda;
import com.espertech.esper.epl.enummethod.dot.PropertyExprEvaluatorNonLambdaFragment;
import com.espertech.esper.epl.enummethod.dot.PropertyExprEvaluatorNonLambdaIndexed;
import com.espertech.esper.epl.enummethod.dot.PropertyExprEvaluatorNonLambdaMapped;
import com.espertech.esper.epl.enummethod.dot.PropertyExprEvaluatorScalarArray;
import com.espertech.esper.epl.enummethod.dot.PropertyExprEvaluatorScalarCollection;
import com.espertech.esper.epl.enummethod.dot.PropertyExprEvaluatorScalarIterable;
import com.espertech.esper.epl.expression.ExprChainedSpec;
import com.espertech.esper.epl.expression.ExprDotEval;
import com.espertech.esper.epl.expression.ExprDotEvalPropertyExprIndexed;
import com.espertech.esper.epl.expression.ExprDotEvalPropertyExprMapped;
import com.espertech.esper.epl.expression.ExprDotEvalRootChild;
import com.espertech.esper.epl.expression.ExprDotEvalStaticMethod;
import com.espertech.esper.epl.expression.ExprDotEvalStreamEventBean;
import com.espertech.esper.epl.expression.ExprDotEvalStreamMethod;
import com.espertech.esper.epl.expression.ExprDotEvalTransposeAsStream;
import com.espertech.esper.epl.expression.ExprDotEvalVariable;
import com.espertech.esper.epl.expression.ExprDotNodeFilterAnalyzerInputExpr;
import com.espertech.esper.epl.expression.ExprDotNodeFilterAnalyzerInputProp;
import com.espertech.esper.epl.expression.ExprDotNodeFilterAnalyzerInputStatic;
import com.espertech.esper.epl.expression.ExprDotNodeFilterAnalyzerInputStream;
import com.espertech.esper.epl.expression.ExprDotNodeRealizedChain;
import com.espertech.esper.epl.expression.ExprDotNodeUtility;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorEnumeration;
import com.espertech.esper.epl.expression.ExprIdentNode;
import com.espertech.esper.epl.expression.ExprIdentNodeUtil;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeBase;
import com.espertech.esper.epl.expression.ExprNodeInnerNodeProvider;
import com.espertech.esper.epl.expression.ExprNodeUtilMethodDesc;
import com.espertech.esper.epl.expression.ExprNodeUtilResolveExceptionHandler;
import com.espertech.esper.epl.expression.ExprNodeUtilResolveExceptionHandlerDefault;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprNodeVisitor;
import com.espertech.esper.epl.expression.ExprNodeVisitorWithParent;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.expression.ExprValidationPropertyException;
import com.espertech.esper.epl.variable.VariableReader;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventTypeUtility;
import com.espertech.esper.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ExprDotNode
extends ExprNodeBase
implements ExprNodeInnerNodeProvider {
    private static final long serialVersionUID = 8105121208330622813L;
    private final List<ExprChainedSpec> chainSpec;
    private final boolean isDuckTyping;
    private final boolean isUDFCache;
    private transient ExprEvaluator exprEvaluator;
    private boolean isReturnsConstantResult;
    private transient ExprDotNodeFilterAnalyzerDesc exprDotNodeFilterAnalyzerDesc;

    public ExprDotNode(List<ExprChainedSpec> chainSpec, boolean isDuckTyping, boolean isUDFCache) {
        this.chainSpec = chainSpec;
        this.isDuckTyping = isDuckTyping;
        this.isUDFCache = isUDFCache;
    }

    @Override
    public void validate(ExprValidationContext validationContext) throws ExprValidationException {
        ExprNodeUtilMethodDesc method;
        ExprNodeUtility.validate(this.chainSpec, validationContext);
        boolean hasEnumerationMethod = false;
        for (ExprChainedSpec chain : this.chainSpec) {
            if (!EnumMethodEnum.isEnumerationMethod(chain.getName())) continue;
            hasEnumerationMethod = true;
            break;
        }
        int prefixedStreamNumber = this.prefixedStreamName(this.chainSpec, validationContext.getStreamTypeService());
        StreamTypeService streamTypeService = validationContext.getStreamTypeService();
        if (this.getChildNodes().length != 0) {
            ExprNode rootNode = this.getChildNodes()[0];
            ExprEvaluator rootNodeEvaluator = rootNode.getExprEvaluator();
            Pair<ExprEvaluatorEnumeration, ExpressionReturnType> enumSrc = ExprDotNode.getEnumerationSource(rootNode, validationContext.getStreamTypeService(), validationContext.getEventAdapterService(), validationContext.getStatementId(), hasEnumerationMethod);
            ExpressionReturnType typeInfo = enumSrc.getSecond() == null ? ExpressionReturnType.singleValue(rootNodeEvaluator.getType()) : enumSrc.getSecond();
            ExprDotNodeRealizedChain evals = ExprDotNodeUtility.getChainEvaluators(typeInfo, this.chainSpec, validationContext, this.isDuckTyping, new ExprDotNodeFilterAnalyzerInputExpr());
            this.exprEvaluator = new ExprDotEvalRootChild(rootNodeEvaluator, enumSrc.getFirst(), typeInfo, evals.getChain(), evals.getChainWithUnpack());
            return;
        }
        if (this.chainSpec.size() == 1) {
            ExprChainedSpec spec = this.chainSpec.get(0);
            if (spec.getParameters().isEmpty()) {
                throw this.handleNotFound(spec.getName());
            }
            Pair<PropertyResolutionDescriptor, String> propertyInfoPair = null;
            try {
                propertyInfoPair = ExprIdentNodeUtil.getTypeFromStream(streamTypeService, spec.getName(), streamTypeService.hasPropertyAgnosticType(), false);
            }
            catch (ExprValidationPropertyException ex) {
                // empty catch block
            }
            if (propertyInfoPair == null && spec.getName().toLowerCase().equals("transpose")) {
                if (spec.getParameters().size() != 1) {
                    throw new ExprValidationException("The transpose function requires a single parameter expression");
                }
                this.exprEvaluator = new ExprDotEvalTransposeAsStream(this.chainSpec.get(0).getParameters().get(0).getExprEvaluator());
            } else {
                if (spec.getParameters().size() != 1) {
                    throw this.handleNotFound(spec.getName());
                }
                if (propertyInfoPair == null) {
                    throw new ExprValidationException("Unknown single-row function, aggregation function or mapped or indexed property named '" + spec.getName() + "' could not be resolved");
                }
                this.exprEvaluator = this.getPropertyPairEvaluator(spec.getParameters().get(0).getExprEvaluator(), propertyInfoPair, validationContext);
            }
            return;
        }
        if (prefixedStreamNumber != -1) {
            ExprChainedSpec specAfterStreamName = this.chainSpec.get(1);
            Pair<PropertyResolutionDescriptor, String> propertyInfoPair = null;
            try {
                String propName = this.chainSpec.get(0).getName() + "." + specAfterStreamName.getName();
                propertyInfoPair = ExprIdentNodeUtil.getTypeFromStream(streamTypeService, propName, streamTypeService.hasPropertyAgnosticType(), false);
            }
            catch (ExprValidationPropertyException ex) {
                // empty catch block
            }
            if (propertyInfoPair != null) {
                if (specAfterStreamName.getParameters().size() != 1) {
                    throw this.handleNotFound(specAfterStreamName.getName());
                }
                this.exprEvaluator = this.getPropertyPairEvaluator(specAfterStreamName.getParameters().get(0).getExprEvaluator(), propertyInfoPair, validationContext);
            } else {
                EventType eventType = validationContext.getStreamTypeService().getEventTypes()[prefixedStreamNumber];
                Class type = eventType.getUnderlyingType();
                ArrayList<ExprChainedSpec> remainderChain = new ArrayList<ExprChainedSpec>(this.chainSpec);
                remainderChain.remove(0);
                ExprValidationException methodEx = null;
                ExprDotEval[] underlyingMethodChain = null;
                try {
                    ExpressionReturnType typeInfo = ExpressionReturnType.singleValue(type);
                    underlyingMethodChain = ExprDotNodeUtility.getChainEvaluators(typeInfo, remainderChain, validationContext, false, new ExprDotNodeFilterAnalyzerInputStream(prefixedStreamNumber)).getChainWithUnpack();
                }
                catch (ExprValidationException ex) {
                    methodEx = ex;
                }
                ExprDotEval[] eventTypeMethodChain = null;
                ExprValidationException enumDatetimeEx = null;
                try {
                    ExpressionReturnType typeInfo = ExpressionReturnType.singleEvent(eventType);
                    ExprDotNodeRealizedChain chain = ExprDotNodeUtility.getChainEvaluators(typeInfo, remainderChain, validationContext, false, new ExprDotNodeFilterAnalyzerInputStream(prefixedStreamNumber));
                    eventTypeMethodChain = chain.getChainWithUnpack();
                    this.exprDotNodeFilterAnalyzerDesc = chain.getFilterAnalyzerDesc();
                }
                catch (ExprValidationException ex) {
                    enumDatetimeEx = ex;
                }
                if (underlyingMethodChain != null) {
                    this.exprEvaluator = new ExprDotEvalStreamMethod(prefixedStreamNumber, underlyingMethodChain);
                } else if (eventTypeMethodChain != null) {
                    this.exprEvaluator = new ExprDotEvalStreamEventBean(prefixedStreamNumber, eventTypeMethodChain);
                } else {
                    if (ExprDotNodeUtility.isDatetimeOrEnumMethod(((ExprChainedSpec)remainderChain.get(0)).getName())) {
                        throw enumDatetimeEx;
                    }
                    throw new ExprValidationException("Failed to solve '" + ((ExprChainedSpec)remainderChain.get(0)).getName() + "' to either an date-time or enumeration method, an event property or a method on the event underlying object: " + methodEx.getMessage(), methodEx);
                }
            }
            return;
        }
        ArrayList<ExprChainedSpec> modifiedChain = new ArrayList<ExprChainedSpec>(this.chainSpec);
        ExprChainedSpec firstItem = (ExprChainedSpec)modifiedChain.remove(0);
        Pair<PropertyResolutionDescriptor, String> propertyInfoPair = null;
        try {
            propertyInfoPair = ExprIdentNodeUtil.getTypeFromStream(streamTypeService, firstItem.getName(), streamTypeService.hasPropertyAgnosticType(), true);
        }
        catch (ExprValidationPropertyException ex) {
            // empty catch block
        }
        if (propertyInfoPair != null) {
            ExprDotNodeRealizedChain evals;
            ExpressionReturnType inputType;
            ExpressionReturnType typeInfo;
            EventPropertyGetter getter;
            String propertyName = ((PropertyResolutionDescriptor)propertyInfoPair.getFirst()).getPropertyName();
            int streamId = propertyInfoPair.getFirst().getStreamNum();
            EventType streamType = streamTypeService.getEventTypes()[streamId];
            ExprEvaluatorEnumeration enumerationEval = null;
            ExprEvaluator rootNodeEvaluator = null;
            if (firstItem.getParameters().isEmpty()) {
                getter = streamType.getGetter(propertyInfoPair.getFirst().getPropertyName());
                Pair<ExprEvaluatorEnumeration, ExpressionReturnType> propertyEval = ExprDotNode.getPropertyEnumerationSource(propertyInfoPair.getFirst().getPropertyName(), streamId, streamType, hasEnumerationMethod);
                typeInfo = propertyEval.getSecond();
                enumerationEval = propertyEval.getFirst();
                inputType = propertyEval.getSecond();
                rootNodeEvaluator = new PropertyExprEvaluatorNonLambda(streamId, getter, propertyInfoPair.getFirst().getPropertyType());
            } else {
                EventPropertyDescriptor desc = EventTypeUtility.getNestablePropertyDescriptor(streamTypeService.getEventTypes()[propertyInfoPair.getFirst().getStreamNum()], firstItem.getName());
                if (firstItem.getParameters().size() > 1) {
                    throw new ExprValidationException("Property '" + firstItem.getName() + "' may not be accessed passing 2 or more parameters");
                }
                ExprEvaluator paramEval = firstItem.getParameters().get(0).getExprEvaluator();
                inputType = typeInfo = ExpressionReturnType.singleValue(desc.getPropertyComponentType());
                getter = null;
                if (desc.isMapped()) {
                    if (paramEval.getType() != String.class) {
                        throw new ExprValidationException("Parameter expression to mapped property '" + propertyName + "' is expected to return a string-type value but returns " + JavaClassHelper.getClassNameFullyQualPretty(paramEval.getType()));
                    }
                    EventPropertyGetterMapped mappedGetter = propertyInfoPair.getFirst().getStreamEventType().getGetterMapped(propertyInfoPair.getFirst().getPropertyName());
                    if (mappedGetter == null) {
                        throw new ExprValidationException("Mapped property named '" + propertyName + "' failed to obtain getter-object");
                    }
                    rootNodeEvaluator = new PropertyExprEvaluatorNonLambdaMapped(streamId, mappedGetter, paramEval, desc.getPropertyComponentType());
                }
                if (desc.isIndexed()) {
                    if (JavaClassHelper.getBoxedType(paramEval.getType()) != Integer.class) {
                        throw new ExprValidationException("Parameter expression to mapped property '" + propertyName + "' is expected to return a Integer-type value but returns " + JavaClassHelper.getClassNameFullyQualPretty(paramEval.getType()));
                    }
                    EventPropertyGetterIndexed indexedGetter = propertyInfoPair.getFirst().getStreamEventType().getGetterIndexed(propertyInfoPair.getFirst().getPropertyName());
                    if (indexedGetter == null) {
                        throw new ExprValidationException("Mapped property named '" + propertyName + "' failed to obtain getter-object");
                    }
                    rootNodeEvaluator = new PropertyExprEvaluatorNonLambdaIndexed(streamId, indexedGetter, paramEval, desc.getPropertyComponentType());
                }
            }
            if (typeInfo == null) {
                throw new ExprValidationException("Property '" + propertyName + "' is not a mapped or indexed property");
            }
            ExprDotNodeFilterAnalyzerInputProp filterAnalyzerInputProp = new ExprDotNodeFilterAnalyzerInputProp(propertyInfoPair.getFirst().getStreamNum(), propertyInfoPair.getFirst().getPropertyName());
            try {
                evals = ExprDotNodeUtility.getChainEvaluators(inputType, modifiedChain, validationContext, this.isDuckTyping, filterAnalyzerInputProp);
            }
            catch (ExprValidationException ex) {
                FragmentEventType fragment = propertyInfoPair.getFirst().getFragmentEventType();
                if (fragment == null) {
                    throw ex;
                }
                ExpressionReturnType fragmentTypeInfo = fragment.isIndexed() ? ExpressionReturnType.collectionOfEvents(fragment.getFragmentType()) : ExpressionReturnType.singleEvent(fragment.getFragmentType());
                evals = ExprDotNodeUtility.getChainEvaluators(fragmentTypeInfo, modifiedChain, validationContext, this.isDuckTyping, filterAnalyzerInputProp);
                rootNodeEvaluator = new PropertyExprEvaluatorNonLambdaFragment(streamId, getter, fragment.getFragmentType().getUnderlyingType());
            }
            this.exprEvaluator = new ExprDotEvalRootChild(rootNodeEvaluator, enumerationEval, inputType, evals.getChain(), evals.getChainWithUnpack());
            this.exprDotNodeFilterAnalyzerDesc = evals.getFilterAnalyzerDesc();
            return;
        }
        VariableReader variableReader = validationContext.getVariableService().getReader(firstItem.getName());
        if (variableReader != null) {
            ExprDotStaticMethodWrapArrayScalar wrap;
            ExpressionReturnType typeInfo;
            if (variableReader.getType().isArray()) {
                typeInfo = ExpressionReturnType.collectionOfSingleValue(variableReader.getType().getComponentType());
                wrap = new ExprDotStaticMethodWrapArrayScalar(variableReader.getVariableName(), variableReader.getType().getComponentType());
            } else if (variableReader.getEventType() != null) {
                typeInfo = ExpressionReturnType.singleEvent(variableReader.getEventType());
                wrap = null;
            } else {
                typeInfo = ExpressionReturnType.singleValue(variableReader.getType());
                wrap = null;
            }
            ExprDotNodeRealizedChain evals = ExprDotNodeUtility.getChainEvaluators(typeInfo, modifiedChain, validationContext, false, new ExprDotNodeFilterAnalyzerInputStatic());
            this.exprEvaluator = new ExprDotEvalVariable(variableReader, wrap, evals.getChainWithUnpack());
            return;
        }
        Object enumconstant = JavaClassHelper.resolveIdentAsEnumConst(firstItem.getName(), validationContext.getMethodResolutionService(), null);
        if (enumconstant != null) {
            final ExprChainedSpec methodSpec = (ExprChainedSpec)modifiedChain.get(0);
            final String enumvalue = firstItem.getName();
            ExprNodeUtilResolveExceptionHandler handler = new ExprNodeUtilResolveExceptionHandler(){

                @Override
                public ExprValidationException handle(Exception ex) {
                    return new ExprValidationException("Failed to resolve method '" + methodSpec.getName() + "' on enumeration value '" + enumvalue + "': " + ex.getMessage());
                }
            };
            EventType wildcardType = validationContext.getStreamTypeService().getEventTypes().length != 1 ? null : validationContext.getStreamTypeService().getEventTypes()[0];
            ExprNodeUtilMethodDesc methodDesc = ExprNodeUtility.resolveMethodAllowWildcardAndStream(enumconstant.getClass().getName(), enumconstant.getClass(), methodSpec.getName(), methodSpec.getParameters(), validationContext.getMethodResolutionService(), validationContext.getEventAdapterService(), validationContext.getStatementId(), wildcardType != null, wildcardType, handler, methodSpec.getName());
            modifiedChain.remove(0);
            ExprDotStaticMethodWrap optionalLambdaWrap = ExprDotStaticMethodWrapFactory.make(methodDesc.getReflectionMethod(), validationContext.getEventAdapterService(), modifiedChain);
            ExpressionReturnType typeInfo = optionalLambdaWrap != null ? optionalLambdaWrap.getTypeInfo() : ExpressionReturnType.singleValue(methodDesc.getFastMethod().getReturnType());
            ExprDotNodeRealizedChain evals = ExprDotNodeUtility.getChainEvaluators(typeInfo, modifiedChain, validationContext, false, new ExprDotNodeFilterAnalyzerInputStatic());
            this.exprEvaluator = new ExprDotEvalStaticMethod(validationContext.getStatementName(), firstItem.getName(), methodDesc.getFastMethod(), methodDesc.getChildEvals(), false, optionalLambdaWrap, evals.getChainWithUnpack(), false, enumconstant);
            return;
        }
        ExprChainedSpec secondItem = (ExprChainedSpec)modifiedChain.remove(0);
        boolean allowWildcard = validationContext.getStreamTypeService().getEventTypes().length == 1;
        EventType streamZeroType = null;
        if (validationContext.getStreamTypeService().getEventTypes().length > 0) {
            streamZeroType = validationContext.getStreamTypeService().getEventTypes()[0];
        }
        boolean isConstantParameters = (method = ExprNodeUtility.resolveMethodAllowWildcardAndStream(firstItem.getName(), null, secondItem.getName(), secondItem.getParameters(), validationContext.getMethodResolutionService(), validationContext.getEventAdapterService(), validationContext.getStatementId(), allowWildcard, streamZeroType, new ExprNodeUtilResolveExceptionHandlerDefault(firstItem.getName() + "." + secondItem.getName(), false), secondItem.getName())).isAllConstants() && this.isUDFCache;
        this.isReturnsConstantResult = isConstantParameters && modifiedChain.isEmpty();
        ExprDotStaticMethodWrap optionalLambdaWrap = ExprDotStaticMethodWrapFactory.make(method.getReflectionMethod(), validationContext.getEventAdapterService(), modifiedChain);
        ExpressionReturnType typeInfo = optionalLambdaWrap != null ? optionalLambdaWrap.getTypeInfo() : ExpressionReturnType.singleValue(method.getReflectionMethod().getReturnType());
        ExprDotNodeRealizedChain evals = ExprDotNodeUtility.getChainEvaluators(typeInfo, modifiedChain, validationContext, false, new ExprDotNodeFilterAnalyzerInputStatic());
        this.exprEvaluator = new ExprDotEvalStaticMethod(validationContext.getStatementName(), firstItem.getName(), method.getFastMethod(), method.getChildEvals(), isConstantParameters, optionalLambdaWrap, evals.getChainWithUnpack(), false, null);
    }

    public ExprDotNodeFilterAnalyzerDesc getExprDotNodeFilterAnalyzerDesc() {
        return this.exprDotNodeFilterAnalyzerDesc;
    }

    private ExprEvaluator getPropertyPairEvaluator(ExprEvaluator parameterEval, Pair<PropertyResolutionDescriptor, String> propertyInfoPair, ExprValidationContext validationContext) throws ExprValidationException {
        String propertyName = propertyInfoPair.getFirst().getPropertyName();
        EventPropertyDescriptor propertyDesc = EventTypeUtility.getNestablePropertyDescriptor(propertyInfoPair.getFirst().getStreamEventType(), propertyName);
        if (propertyDesc == null || !propertyDesc.isMapped() && !propertyDesc.isIndexed()) {
            throw new ExprValidationException("Unknown single-row function, aggregation function or mapped or indexed property named '" + propertyName + "' could not be resolved");
        }
        int streamNum = propertyInfoPair.getFirst().getStreamNum();
        if (propertyDesc.isMapped()) {
            if (parameterEval.getType() != String.class) {
                throw new ExprValidationException("Parameter expression to mapped property '" + propertyDesc.getPropertyName() + "' is expected to return a string-type value but returns " + JavaClassHelper.getClassNameFullyQualPretty(parameterEval.getType()));
            }
            EventPropertyGetterMapped mappedGetter = propertyInfoPair.getFirst().getStreamEventType().getGetterMapped(propertyInfoPair.getFirst().getPropertyName());
            if (mappedGetter == null) {
                throw new ExprValidationException("Mapped property named '" + propertyName + "' failed to obtain getter-object");
            }
            return new ExprDotEvalPropertyExprMapped(validationContext.getStatementName(), propertyDesc.getPropertyName(), streamNum, parameterEval, propertyDesc.getPropertyComponentType(), mappedGetter);
        }
        if (JavaClassHelper.getBoxedType(parameterEval.getType()) != Integer.class) {
            throw new ExprValidationException("Parameter expression to indexed property '" + propertyDesc.getPropertyName() + "' is expected to return a Integer-type value but returns " + JavaClassHelper.getClassNameFullyQualPretty(parameterEval.getType()));
        }
        EventPropertyGetterIndexed indexedGetter = propertyInfoPair.getFirst().getStreamEventType().getGetterIndexed(propertyInfoPair.getFirst().getPropertyName());
        if (indexedGetter == null) {
            throw new ExprValidationException("Indexed property named '" + propertyName + "' failed to obtain getter-object");
        }
        return new ExprDotEvalPropertyExprIndexed(validationContext.getStatementName(), propertyDesc.getPropertyName(), streamNum, parameterEval, propertyDesc.getPropertyComponentType(), indexedGetter);
    }

    private int prefixedStreamName(List<ExprChainedSpec> chainSpec, StreamTypeService streamTypeService) {
        if (chainSpec.size() < 1) {
            return -1;
        }
        ExprChainedSpec spec = chainSpec.get(0);
        if (spec.getParameters().size() > 0 && !spec.isProperty()) {
            return -1;
        }
        return streamTypeService.getStreamNumForStreamName(spec.getName());
    }

    @Override
    public void accept(ExprNodeVisitor visitor) {
        super.accept(visitor);
        ExprNodeUtility.acceptChain(visitor, this.chainSpec);
    }

    @Override
    public void accept(ExprNodeVisitorWithParent visitor) {
        super.accept(visitor);
        ExprNodeUtility.acceptChain(visitor, this.chainSpec);
    }

    @Override
    public void acceptChildnodes(ExprNodeVisitorWithParent visitor, ExprNode parent) {
        super.acceptChildnodes(visitor, parent);
        ExprNodeUtility.acceptChain(visitor, this.chainSpec, this);
    }

    @Override
    public void replaceUnlistedChildNode(ExprNode nodeToReplace, ExprNode newNode) {
        ExprNodeUtility.replaceChainChildNode(nodeToReplace, newNode, this.chainSpec);
    }

    public List<ExprChainedSpec> getChainSpec() {
        return this.chainSpec;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this.exprEvaluator;
    }

    @Override
    public boolean isConstantResult() {
        return this.isReturnsConstantResult;
    }

    @Override
    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        if (this.getChildNodes().length != 0) {
            buffer.append('(');
            buffer.append(this.getChildNodes()[0].toExpressionString());
            buffer.append(")");
        }
        ExprNodeUtility.toExpressionString(this.chainSpec, buffer, this.getChildNodes().length != 0, null);
        return buffer.toString();
    }

    public Map<String, Object> getEventType() {
        return null;
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprDotNode)) {
            return false;
        }
        ExprDotNode other = (ExprDotNode)node;
        if (other.chainSpec.size() != this.chainSpec.size()) {
            return false;
        }
        for (int i = 0; i < this.chainSpec.size(); ++i) {
            if (this.chainSpec.get(i).equals(other.chainSpec.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<ExprNode> getAdditionalNodes() {
        return ExprNodeUtility.collectChainParameters(this.chainSpec);
    }

    public static Pair<ExprEvaluatorEnumeration, ExpressionReturnType> getEnumerationSource(ExprNode inputExpression, StreamTypeService streamTypeService, EventAdapterService eventAdapterService, String statementId, boolean hasEnumerationMethod) throws ExprValidationException {
        ExprEvaluator rootNodeEvaluator = inputExpression.getExprEvaluator();
        ExprEvaluatorEnumeration rootLambdaEvaluator = null;
        ExpressionReturnType info = null;
        if (rootNodeEvaluator instanceof ExprEvaluatorEnumeration) {
            rootLambdaEvaluator = (ExprEvaluatorEnumeration)((Object)rootNodeEvaluator);
            if (rootLambdaEvaluator.getEventTypeCollection(eventAdapterService) != null) {
                info = ExpressionReturnType.collectionOfEvents(rootLambdaEvaluator.getEventTypeCollection(eventAdapterService));
            } else if (rootLambdaEvaluator.getEventTypeSingle(eventAdapterService, statementId) != null) {
                info = ExpressionReturnType.singleEvent(rootLambdaEvaluator.getEventTypeSingle(eventAdapterService, statementId));
            } else if (rootLambdaEvaluator.getComponentTypeCollection() != null) {
                info = ExpressionReturnType.collectionOfSingleValue(rootLambdaEvaluator.getComponentTypeCollection());
            } else {
                rootLambdaEvaluator = null;
            }
        } else if (inputExpression instanceof ExprIdentNode) {
            ExprIdentNode identNode = (ExprIdentNode)inputExpression;
            int streamId = identNode.getStreamId();
            EventType streamType = streamTypeService.getEventTypes()[streamId];
            return ExprDotNode.getPropertyEnumerationSource(identNode.getResolvedPropertyName(), streamId, streamType, hasEnumerationMethod);
        }
        return new Pair<ExprEvaluatorEnumeration, Object>(rootLambdaEvaluator, info);
    }

    public static Pair<ExprEvaluatorEnumeration, ExpressionReturnType> getPropertyEnumerationSource(String propertyName, int streamId, EventType streamType, boolean hasEnumerationMethod) {
        EventPropertyGetter getter = streamType.getGetter(propertyName);
        FragmentEventType fragmentEventType = streamType.getFragmentType(propertyName);
        Class propertyType = streamType.getPropertyType(propertyName);
        ExpressionReturnType typeInfo = ExpressionReturnType.singleValue(propertyType);
        if (!hasEnumerationMethod) {
            return new Pair<Object, ExpressionReturnType>(null, typeInfo);
        }
        ExprEvaluatorEnumeration enumEvaluator = null;
        if (getter != null && fragmentEventType != null && fragmentEventType.isIndexed()) {
            enumEvaluator = new PropertyExprEvaluatorEventCollection(propertyName, streamId, fragmentEventType.getFragmentType(), getter);
            typeInfo = ExpressionReturnType.collectionOfEvents(fragmentEventType.getFragmentType());
        } else {
            EventPropertyDescriptor desc = EventTypeUtility.getNestablePropertyDescriptor(streamType, propertyName);
            if (desc != null && desc.isIndexed() && !desc.isRequiresIndex() && desc.getPropertyComponentType() != null) {
                if (JavaClassHelper.isImplementsInterface(propertyType, Collection.class)) {
                    enumEvaluator = new PropertyExprEvaluatorScalarCollection(propertyName, streamId, getter, desc.getPropertyComponentType());
                } else if (JavaClassHelper.isImplementsInterface(propertyType, Iterable.class)) {
                    enumEvaluator = new PropertyExprEvaluatorScalarIterable(propertyName, streamId, getter, desc.getPropertyComponentType());
                } else if (propertyType.isArray()) {
                    enumEvaluator = new PropertyExprEvaluatorScalarArray(propertyName, streamId, getter, desc.getPropertyComponentType());
                } else {
                    throw new IllegalStateException("Property indicated indexed-type but failed to find proper collection adapter for use with enumeration methods");
                }
                typeInfo = ExpressionReturnType.collectionOfSingleValue(desc.getPropertyComponentType());
            }
        }
        return new Pair<Object, ExpressionReturnType>(enumEvaluator, typeInfo);
    }

    private ExprValidationException handleNotFound(String name) {
        return new ExprValidationException("Unknown single-row function, expression declaration, script or aggregation function named '" + name + "' could not be resolved");
    }
}

