/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.util.ExpressionReturnType;
import com.espertech.esper.epl.datetime.eval.DatetimeMethodEnum;
import com.espertech.esper.epl.datetime.eval.ExprDotEvalDTFactory;
import com.espertech.esper.epl.datetime.eval.ExprDotEvalDTMethodDesc;
import com.espertech.esper.epl.datetime.eval.ExprDotNodeFilterAnalyzerDesc;
import com.espertech.esper.epl.enummethod.dot.EnumMethodEnum;
import com.espertech.esper.epl.enummethod.dot.ExprDotEvalEnumMethod;
import com.espertech.esper.epl.enummethod.dot.ExprDotEvalProperty;
import com.espertech.esper.epl.enummethod.dot.ExprDotEvalUnpackBean;
import com.espertech.esper.epl.enummethod.dot.ExprDotEvalUnpackCollEventBean;
import com.espertech.esper.epl.expression.ExprChainedSpec;
import com.espertech.esper.epl.expression.ExprDotEval;
import com.espertech.esper.epl.expression.ExprDotEvalArrayGet;
import com.espertech.esper.epl.expression.ExprDotEvalArraySize;
import com.espertech.esper.epl.expression.ExprDotMethodEvalDuck;
import com.espertech.esper.epl.expression.ExprDotMethodEvalNoDuck;
import com.espertech.esper.epl.expression.ExprDotMethodEvalNoDuckUnderlying;
import com.espertech.esper.epl.expression.ExprDotMethodEvalNoDuckWrapArray;
import com.espertech.esper.epl.expression.ExprDotNodeFilterAnalyzerInput;
import com.espertech.esper.epl.expression.ExprDotNodeRealizedChain;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprNodeUtilMethodDesc;
import com.espertech.esper.epl.expression.ExprNodeUtilResolveExceptionHandler;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.event.EventTypeMetadata;
import com.espertech.esper.event.arr.ObjectArrayEventType;
import com.espertech.esper.util.JavaClassHelper;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.cglib.reflect.FastMethod;

public class ExprDotNodeUtility {
    public static boolean isDatetimeOrEnumMethod(String name) {
        return EnumMethodEnum.isEnumerationMethod(name) || DatetimeMethodEnum.isDateTimeMethod(name);
    }

    public static ExprDotNodeRealizedChain getChainEvaluators(ExpressionReturnType inputType, List<ExprChainedSpec> chainSpec, ExprValidationContext validationContext, boolean isDuckTyping, ExprDotNodeFilterAnalyzerInput inputDesc) throws ExprValidationException {
        ArrayList<ExprDotEval> methodEvals = new ArrayList<ExprDotEval>();
        ExpressionReturnType currentInputType = inputType;
        EnumMethodEnum lastLambdaFunc = null;
        ExprChainedSpec lastElement = chainSpec.isEmpty() ? null : chainSpec.get(chainSpec.size() - 1);
        ExprDotNodeFilterAnalyzerDesc filterAnalyzerDesc = null;
        ArrayDeque<ExprChainedSpec> chainSpecStack = new ArrayDeque<ExprChainedSpec>(chainSpec);
        while (!chainSpecStack.isEmpty()) {
            EventType wildcardType;
            ExprNodeUtilResolveExceptionHandler exceptionHandler;
            ExprChainedSpec chainElement = (ExprChainedSpec)chainSpecStack.removeFirst();
            lastLambdaFunc = null;
            ExprEvaluator[] paramEvals = new ExprEvaluator[chainElement.getParameters().size()];
            Class[] paramTypes = new Class[chainElement.getParameters().size()];
            for (int i = 0; i < chainElement.getParameters().size(); ++i) {
                paramEvals[i] = chainElement.getParameters().get(i).getExprEvaluator();
                paramTypes[i] = paramEvals[i].getType();
            }
            if (currentInputType.isSingleValueNonNull() && currentInputType.getSingleValueType().isArray() || currentInputType.getComponentType() != null) {
                if (chainElement.getName().toLowerCase().equals("size") && paramTypes.length == 0 && lastElement == chainElement) {
                    ExprDotEvalArraySize sizeExpr = new ExprDotEvalArraySize();
                    methodEvals.add(sizeExpr);
                    currentInputType = sizeExpr.getTypeInfo();
                    continue;
                }
                if (chainElement.getName().toLowerCase().equals("get") && paramTypes.length == 1 && JavaClassHelper.getBoxedType(paramTypes[0]) == Integer.class) {
                    Class<?> componentType = currentInputType.getComponentType() != null ? currentInputType.getComponentType() : currentInputType.getSingleValueType().getComponentType();
                    ExprDotEvalArrayGet get = new ExprDotEvalArrayGet(paramEvals[0], componentType);
                    methodEvals.add(get);
                    currentInputType = get.getTypeInfo();
                    continue;
                }
            }
            if (EnumMethodEnum.isEnumerationMethod(chainElement.getName())) {
                EnumMethodEnum enumerationMethod = EnumMethodEnum.fromName(chainElement.getName());
                ExprDotEvalEnumMethod eval = (ExprDotEvalEnumMethod)JavaClassHelper.instantiate(ExprDotEvalEnumMethod.class, enumerationMethod.getImplementation().getName());
                eval.init(enumerationMethod, chainElement.getName(), currentInputType, chainElement.getParameters(), validationContext);
                currentInputType = eval.getTypeInfo();
                if (currentInputType == null) {
                    throw new IllegalStateException("Enumeration method '" + chainElement.getName() + "' has not returned type information");
                }
                methodEvals.add(eval);
                lastLambdaFunc = enumerationMethod;
                continue;
            }
            if (DatetimeMethodEnum.isDateTimeMethod(chainElement.getName())) {
                DatetimeMethodEnum datetimeMethod = DatetimeMethodEnum.fromName(chainElement.getName());
                ExprDotEvalDTMethodDesc datetimeImpl = ExprDotEvalDTFactory.validateMake(validationContext.getStreamTypeService(), chainSpecStack, datetimeMethod, chainElement.getName(), currentInputType, chainElement.getParameters(), inputDesc);
                currentInputType = datetimeImpl.getReturnType();
                if (currentInputType == null) {
                    throw new IllegalStateException("Date-time method '" + chainElement.getName() + "' has not returned type information");
                }
                methodEvals.add(datetimeImpl.getEval());
                filterAnalyzerDesc = datetimeImpl.getIntervalFilterDesc();
                continue;
            }
            if (currentInputType.getSingleEventEventType() != null) {
                Class type = currentInputType.getSingleEventEventType().getPropertyType(chainElement.getName());
                EventPropertyGetter getter = currentInputType.getSingleEventEventType().getGetter(chainElement.getName());
                if (type != null && getter != null) {
                    ExprDotEvalProperty noduck = new ExprDotEvalProperty(getter, ExpressionReturnType.singleValue(JavaClassHelper.getBoxedType(type)));
                    methodEvals.add(noduck);
                    currentInputType = ExpressionReturnType.singleValue(noduck.getTypeInfo().getSingleValueType());
                    continue;
                }
                try {
                    if (currentInputType.isSingleValueNonNull()) {
                        exceptionHandler = new ExprNodeUtilResolveExceptionHandler(){

                            @Override
                            public ExprValidationException handle(Exception e) {
                                return new ExprValidationException("Failed to resolve");
                            }
                        };
                        wildcardType = validationContext.getStreamTypeService().getEventTypes().length != 1 ? null : validationContext.getStreamTypeService().getEventTypes()[0];
                        ExprNodeUtility.resolveMethodAllowWildcardAndStream(currentInputType.getSingleValueType().getName(), currentInputType.getSingleValueType(), chainElement.getName(), chainElement.getParameters(), validationContext.getMethodResolutionService(), validationContext.getEventAdapterService(), validationContext.getStatementId(), wildcardType != null, wildcardType, exceptionHandler, chainElement.getName());
                    }
                }
                catch (Exception ex) {
                    throw new ExprValidationException("Could not resolve '" + chainElement.getName() + "' to a property of event type '" + currentInputType.getSingleEventEventType().getName() + "' or method on type '" + currentInputType + "'");
                }
            }
            if (currentInputType.isSingleValueNonNull() || currentInputType.getSingleEventEventType() != null) {
                try {
                    Class target = currentInputType.isSingleValueNonNull() ? currentInputType.getSingleValueType() : currentInputType.getSingleEventEventType().getUnderlyingType();
                    final String methodName = chainElement.getName();
                    exceptionHandler = new ExprNodeUtilResolveExceptionHandler(){

                        @Override
                        public ExprValidationException handle(Exception e) {
                            return new ExprValidationException("Failed to resolve method '" + methodName + "': " + e.getMessage(), e);
                        }
                    };
                    wildcardType = validationContext.getStreamTypeService().getEventTypes().length != 1 ? null : validationContext.getStreamTypeService().getEventTypes()[0];
                    ExprNodeUtilMethodDesc desc = ExprNodeUtility.resolveMethodAllowWildcardAndStream(target.getName(), target, methodName, chainElement.getParameters(), validationContext.getMethodResolutionService(), validationContext.getEventAdapterService(), validationContext.getStatementId(), wildcardType != null, wildcardType, exceptionHandler, methodName);
                    FastMethod fastMethod = desc.getFastMethod();
                    paramEvals = desc.getChildEvals();
                    ExprDotMethodEvalNoDuck eval = currentInputType.isSingleValueNonNull() ? (fastMethod.getReturnType().isArray() && !chainSpecStack.isEmpty() && EnumMethodEnum.isEnumerationMethod(((ExprChainedSpec)chainSpecStack.getFirst()).getName()) ? new ExprDotMethodEvalNoDuckWrapArray(validationContext.getStatementName(), fastMethod, paramEvals) : new ExprDotMethodEvalNoDuck(validationContext.getStatementName(), fastMethod, paramEvals)) : new ExprDotMethodEvalNoDuckUnderlying(validationContext.getStatementName(), fastMethod, paramEvals);
                    methodEvals.add(eval);
                    currentInputType = eval.getTypeInfo();
                }
                catch (Exception e) {
                    if (!isDuckTyping) {
                        throw new ExprValidationException(e.getMessage(), e);
                    }
                    ExprDotMethodEvalDuck duck = new ExprDotMethodEvalDuck(validationContext.getStatementName(), validationContext.getMethodResolutionService(), chainElement.getName(), paramTypes, paramEvals);
                    methodEvals.add(duck);
                    currentInputType = duck.getTypeInfo();
                }
                continue;
            }
            String message = "Could not find event property, enumeration method or instance method named '" + chainElement.getName() + "' in " + currentInputType.toTypeDescriptive();
            throw new ExprValidationException(message);
        }
        ExprDotEval[] intermediateEvals = methodEvals.toArray(new ExprDotEval[methodEvals.size()]);
        if (lastLambdaFunc != null) {
            if (currentInputType.getCollOfEventEventType() != null) {
                methodEvals.add(new ExprDotEvalUnpackCollEventBean(currentInputType.getCollOfEventEventType()));
            } else if (currentInputType.getSingleEventEventType() != null) {
                methodEvals.add(new ExprDotEvalUnpackBean(currentInputType.getSingleEventEventType()));
            }
        }
        ExprDotEval[] unpackingEvals = methodEvals.toArray(new ExprDotEval[methodEvals.size()]);
        return new ExprDotNodeRealizedChain(intermediateEvals, unpackingEvals, filterAnalyzerDesc);
    }

    public static ObjectArrayEventType makeTransientOAType(String enumMethod, String propertyName, Class type) {
        HashMap<String, Object> propsResult = new HashMap<String, Object>();
        propsResult.put(propertyName, type);
        String typeName = enumMethod + "__" + propertyName;
        return new ObjectArrayEventType(EventTypeMetadata.createAnonymous(typeName), typeName, 0, null, propsResult, null, null, null);
    }

    public static EventType[] getSingleLambdaParamEventType(String enumMethodUsedName, List<String> goesToNames, EventType inputEventType, Class collectionComponentType) {
        if (inputEventType != null) {
            return new EventType[]{inputEventType};
        }
        return new EventType[]{ExprDotNodeUtility.makeTransientOAType(enumMethodUsedName, goesToNames.get(0), collectionComponentType)};
    }
}

