/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.annotation.AuditEnum;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorEnumeration;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.util.AuditPath;
import com.espertech.esper.util.JavaClassHelper;
import java.io.StringWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;

public class ExprEvaluatorProxy
implements InvocationHandler {
    private static Method targetEvaluate = JavaClassHelper.getMethodByName(ExprEvaluator.class, "evaluate");
    private static Method targetEvaluateCollEvents = JavaClassHelper.getMethodByName(ExprEvaluatorEnumeration.class, "evaluateGetROCollectionEvents");
    private static Method targetEvaluateCollScalar = JavaClassHelper.getMethodByName(ExprEvaluatorEnumeration.class, "evaluateGetROCollectionScalar");
    private static Method targetEvaluateBean = JavaClassHelper.getMethodByName(ExprEvaluatorEnumeration.class, "evaluateGetEventBean");
    private final String engineURI;
    private final String statementName;
    private final String expressionToString;
    private final ExprEvaluator evaluator;

    public static Object newInstance(String engineURI, String statementName, String expressionToString, ExprEvaluator evaluator) {
        return Proxy.newProxyInstance(evaluator.getClass().getClassLoader(), JavaClassHelper.getSuperInterfaces(evaluator.getClass()), (InvocationHandler)new ExprEvaluatorProxy(engineURI, statementName, expressionToString, evaluator));
    }

    public ExprEvaluatorProxy(String engineURI, String statementName, String expressionToString, ExprEvaluator evaluator) {
        this.engineURI = engineURI;
        this.statementName = statementName;
        this.expressionToString = expressionToString;
        this.evaluator = evaluator;
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        if (m.equals(targetEvaluate)) {
            Object result = m.invoke((Object)this.evaluator, args);
            if (AuditPath.isInfoEnabled()) {
                AuditPath.auditLog(this.engineURI, this.statementName, AuditEnum.EXPRESSION, this.expressionToString + " result " + result);
            }
            return result;
        }
        if (m.equals(targetEvaluateCollEvents)) {
            Object result = m.invoke((Object)this.evaluator, args);
            if (AuditPath.isInfoEnabled()) {
                Collection resultBeans = (Collection)result;
                String outStr = "null";
                if (resultBeans != null) {
                    if (resultBeans.isEmpty()) {
                        outStr = "{}";
                    } else {
                        StringWriter buf = new StringWriter();
                        int count = 0;
                        for (EventBean theEvent : resultBeans) {
                            buf.append(" Event ");
                            buf.append(Integer.toString(count++));
                            buf.append(":");
                            EventBeanUtility.appendEvent(buf, theEvent);
                        }
                        outStr = buf.toString();
                    }
                }
                AuditPath.auditLog(this.engineURI, this.statementName, AuditEnum.EXPRESSION, this.expressionToString + " result " + outStr);
            }
            return result;
        }
        if (m.equals(targetEvaluateCollScalar)) {
            Object result = m.invoke((Object)this.evaluator, args);
            if (AuditPath.isInfoEnabled()) {
                AuditPath.auditLog(this.engineURI, this.statementName, AuditEnum.EXPRESSION, this.expressionToString + " result " + result);
            }
            return result;
        }
        if (m.equals(targetEvaluateBean)) {
            Object result = m.invoke((Object)this.evaluator, args);
            if (AuditPath.isInfoEnabled()) {
                String outStr = "null";
                if (result != null) {
                    StringWriter buf = new StringWriter();
                    EventBeanUtility.appendEvent(buf, (EventBean)result);
                    outStr = buf.toString();
                }
                AuditPath.auditLog(this.engineURI, this.statementName, AuditEnum.EXPRESSION, this.expressionToString + " result " + outStr);
            }
            return result;
        }
        return m.invoke((Object)this.evaluator, args);
    }
}

