/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprIdentNodeEvaluator;
import com.espertech.esper.epl.expression.ExprValidationException;
import java.util.Map;

public class ExprIdentNodeEvaluatorImpl
implements ExprIdentNodeEvaluator {
    private final int streamNum;
    private final EventPropertyGetter propertyGetter;
    private final Class propertyType;

    public ExprIdentNodeEvaluatorImpl(int streamNum, EventPropertyGetter propertyGetter, Class propertyType) {
        this.streamNum = streamNum;
        this.propertyGetter = propertyGetter;
        this.propertyType = propertyType;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        EventBean theEvent = eventsPerStream[this.streamNum];
        if (theEvent == null) {
            return null;
        }
        return this.propertyGetter.get(theEvent);
    }

    @Override
    public Class getType() {
        return this.propertyType;
    }

    @Override
    public Map<String, Object> getEventType() throws ExprValidationException {
        return null;
    }

    @Override
    public EventPropertyGetter getGetter() {
        return this.propertyGetter;
    }

    @Override
    public boolean evaluatePropertyExists(EventBean[] eventsPerStream, boolean isNewData) {
        EventBean theEvent = eventsPerStream[this.streamNum];
        if (theEvent == null) {
            return false;
        }
        return this.propertyGetter.isExistsProperty(theEvent);
    }

    @Override
    public int getStreamNum() {
        return this.streamNum;
    }

    @Override
    public boolean isContextEvaluated() {
        return false;
    }
}

