/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeBase;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.LikeUtil;
import java.util.Map;

public class ExprLikeNode
extends ExprNodeBase
implements ExprEvaluator {
    private final boolean isNot;
    private boolean isNumericValue;
    private boolean isConstantPattern;
    private transient LikeUtil likeUtil;
    private transient ExprEvaluator[] evaluators;
    private static final long serialVersionUID = 34888860063217132L;

    public ExprLikeNode(boolean not) {
        this.isNot = not;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public void validate(ExprValidationContext validationContext) throws ExprValidationException {
        ExprEvaluator escapeChildNode;
        if (this.getChildNodes().length != 2 && this.getChildNodes().length != 3) {
            throw new ExprValidationException("The 'like' operator requires 2 (no escape) or 3 (with escape) child expressions");
        }
        this.evaluators = ExprNodeUtility.getEvaluators(this.getChildNodes());
        Class evalChildType = this.evaluators[0].getType();
        this.isNumericValue = JavaClassHelper.isNumeric(evalChildType);
        if (evalChildType != String.class && !this.isNumericValue) {
            throw new ExprValidationException("The 'like' operator requires a String or numeric type left-hand expression");
        }
        ExprEvaluator patternChildNode = this.evaluators[1];
        Class patternChildType = patternChildNode.getType();
        if (patternChildType != String.class) {
            throw new ExprValidationException("The 'like' operator requires a String-type pattern expression");
        }
        if (this.getChildNodes()[1].isConstantResult()) {
            this.isConstantPattern = true;
        }
        if (this.getChildNodes().length == 3 && (escapeChildNode = this.evaluators[2]).getType() != String.class) {
            throw new ExprValidationException("The 'like' operator escape parameter requires a character-type value");
        }
    }

    @Override
    public Class getType() {
        return Boolean.class;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public Map<String, Object> getEventType() {
        return null;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        String patternVal;
        if (this.likeUtil == null) {
            patternVal = (String)this.evaluators[1].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (patternVal == null) {
                return null;
            }
            String escape = "\\";
            Character escapeCharacter = null;
            if (this.getChildNodes().length == 3) {
                escape = (String)this.evaluators[2].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            }
            if (escape.length() > 0) {
                escapeCharacter = Character.valueOf(escape.charAt(0));
            }
            this.likeUtil = new LikeUtil(patternVal, escapeCharacter, false);
        } else if (!this.isConstantPattern) {
            patternVal = (String)this.evaluators[1].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (patternVal == null) {
                return null;
            }
            this.likeUtil.resetPattern(patternVal);
        }
        Object evalValue = this.evaluators[0].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (evalValue == null) {
            return null;
        }
        if (this.isNumericValue) {
            evalValue = evalValue.toString();
        }
        Boolean result = this.likeUtil.compare((String)evalValue);
        if (this.isNot) {
            return result == false;
        }
        return result;
    }

    @Override
    public boolean equalsNode(ExprNode node_) {
        if (!(node_ instanceof ExprLikeNode)) {
            return false;
        }
        ExprLikeNode other = (ExprLikeNode)node_;
        return this.isNot == other.isNot;
    }

    @Override
    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getChildNodes()[0].toExpressionString());
        if (this.isNot) {
            buffer.append(" not");
        }
        buffer.append(" like ");
        buffer.append(this.getChildNodes()[1].toExpressionString());
        if (this.getChildNodes().length == 3) {
            buffer.append(" escape ");
            buffer.append(this.getChildNodes()[2].toExpressionString());
        }
        return buffer.toString();
    }

    public boolean isNot() {
        return this.isNot;
    }
}

