/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeBase;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.type.MathArithTypeEnum;
import com.espertech.esper.util.JavaClassHelper;
import java.math.BigDecimal;
import java.util.Map;

public class ExprMathNode
extends ExprNodeBase
implements ExprEvaluator {
    private final MathArithTypeEnum mathArithTypeEnum;
    private final boolean isIntegerDivision;
    private final boolean isDivisionByZeroReturnsNull;
    private transient MathArithTypeEnum.Computer arithTypeEnumComputer;
    private Class resultType;
    private transient ExprEvaluator evaluatorLeft;
    private transient ExprEvaluator evaluatorRight;
    private static final long serialVersionUID = 6479683588602862158L;

    public ExprMathNode(MathArithTypeEnum mathArithTypeEnum, boolean isIntegerDivision, boolean isDivisionByZeroReturnsNull) {
        this.mathArithTypeEnum = mathArithTypeEnum;
        this.isIntegerDivision = isIntegerDivision;
        this.isDivisionByZeroReturnsNull = isDivisionByZeroReturnsNull;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public void validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.getChildNodes().length != 2) {
            throw new ExprValidationException("Arithmatic node must have 2 child nodes");
        }
        for (ExprNode child : this.getChildNodes()) {
            Class childType = child.getExprEvaluator().getType();
            if (JavaClassHelper.isNumeric(childType)) continue;
            throw new ExprValidationException("Implicit conversion from datatype '" + childType.getSimpleName() + "' to numeric is not allowed");
        }
        this.evaluatorLeft = this.getChildNodes()[0].getExprEvaluator();
        this.evaluatorRight = this.getChildNodes()[1].getExprEvaluator();
        Class childTypeOne = this.evaluatorLeft.getType();
        Class childTypeTwo = this.evaluatorRight.getType();
        this.resultType = !(childTypeOne != Short.TYPE && childTypeOne != Short.class || childTypeTwo != Short.TYPE && childTypeTwo != Short.class) ? Integer.class : (!(childTypeOne != Byte.TYPE && childTypeOne != Byte.class || childTypeTwo != Byte.TYPE && childTypeTwo != Byte.class) ? Integer.class : (childTypeOne.equals(childTypeTwo) ? JavaClassHelper.getBoxedType(childTypeTwo) : JavaClassHelper.getArithmaticCoercionType(childTypeOne, childTypeTwo)));
        if (this.mathArithTypeEnum == MathArithTypeEnum.DIVIDE && !this.isIntegerDivision && this.resultType != BigDecimal.class) {
            this.resultType = Double.class;
        }
        this.arithTypeEnumComputer = this.mathArithTypeEnum.getComputer(this.resultType, childTypeOne, childTypeTwo, this.isIntegerDivision, this.isDivisionByZeroReturnsNull);
    }

    @Override
    public Class getType() {
        return this.resultType;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public Map<String, Object> getEventType() {
        return null;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object valueChildOne = this.evaluatorLeft.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (valueChildOne == null) {
            return null;
        }
        Object valueChildTwo = this.evaluatorRight.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (valueChildTwo == null) {
            return null;
        }
        return this.arithTypeEnumComputer.compute((Number)valueChildOne, (Number)valueChildTwo);
    }

    @Override
    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('(');
        buffer.append(this.getChildNodes()[0].toExpressionString());
        buffer.append(this.mathArithTypeEnum.getExpressionText());
        buffer.append(this.getChildNodes()[1].toExpressionString());
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprMathNode)) {
            return false;
        }
        ExprMathNode other = (ExprMathNode)node;
        return other.mathArithTypeEnum == this.mathArithTypeEnum;
    }

    public MathArithTypeEnum getMathArithTypeEnum() {
        return this.mathArithTypeEnum;
    }
}

