/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.epl.agg.service.AggregationMethodFactory;
import com.espertech.esper.epl.expression.ExprAggregateNode;
import com.espertech.esper.epl.expression.ExprAggregateNodeBase;
import com.espertech.esper.epl.expression.ExprMinMaxAggrNodeFactory;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.type.MinMaxTypeEnum;

public class ExprMinMaxAggrNode
extends ExprAggregateNodeBase {
    private final MinMaxTypeEnum minMaxTypeEnum;
    private static final long serialVersionUID = -7828413362615586145L;
    private final boolean hasFilter;

    public ExprMinMaxAggrNode(boolean distinct, MinMaxTypeEnum minMaxTypeEnum, boolean hasFilter) {
        super(distinct);
        this.minMaxTypeEnum = minMaxTypeEnum;
        this.hasFilter = hasFilter;
    }

    @Override
    public AggregationMethodFactory validateAggregationChild(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.getChildNodes().length == 0 || this.getChildNodes().length > 2) {
            throw new ExprValidationException(this.minMaxTypeEnum.toString() + " node must have either 1 or 2 child nodes");
        }
        ExprNode child = this.getChildNodes()[0];
        boolean hasDataWindows = ExprNodeUtility.hasRemoveStream(child, validationContext.getStreamTypeService());
        if (this.hasFilter) {
            if (this.getChildNodes().length < 2) {
                throw new ExprValidationException(this.minMaxTypeEnum.toString() + "-filtered aggregation function must have a filter expression as a second parameter");
            }
            super.validateFilter(this.getChildNodes()[1].getExprEvaluator());
        }
        return new ExprMinMaxAggrNodeFactory(this.minMaxTypeEnum, child.getExprEvaluator().getType(), hasDataWindows, super.isDistinct(), this.hasFilter);
    }

    @Override
    public final boolean equalsNodeAggregate(ExprAggregateNode node) {
        if (!(node instanceof ExprMinMaxAggrNode)) {
            return false;
        }
        ExprMinMaxAggrNode other = (ExprMinMaxAggrNode)node;
        return other.minMaxTypeEnum == this.minMaxTypeEnum;
    }

    public MinMaxTypeEnum getMinMaxTypeEnum() {
        return this.minMaxTypeEnum;
    }

    @Override
    protected String getAggregationFunctionName() {
        return this.minMaxTypeEnum.getExpressionText();
    }
}

