/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprNodeVisitor;
import com.espertech.esper.epl.expression.ExprNodeVisitorWithParent;
import com.espertech.esper.util.CollectionUtil;
import java.util.Collection;

public abstract class ExprNodeBase
implements ExprNode {
    private static final long serialVersionUID = 0L;
    private ExprNode[] childNodes = ExprNodeUtility.EMPTY_EXPR_ARRAY;

    @Override
    public void accept(ExprNodeVisitor visitor) {
        if (visitor.isVisit(this)) {
            visitor.visit(this);
            for (ExprNode childNode : this.childNodes) {
                childNode.accept(visitor);
            }
        }
    }

    @Override
    public void accept(ExprNodeVisitorWithParent visitor) {
        if (visitor.isVisit(this)) {
            visitor.visit(this, null);
            for (ExprNode childNode : this.childNodes) {
                childNode.acceptChildnodes(visitor, this);
            }
        }
    }

    @Override
    public void acceptChildnodes(ExprNodeVisitorWithParent visitor, ExprNode parent) {
        if (visitor.isVisit(this)) {
            visitor.visit(this, parent);
            for (ExprNode childNode : this.childNodes) {
                childNode.acceptChildnodes(visitor, this);
            }
        }
    }

    @Override
    public final void addChildNode(ExprNode childNode) {
        this.childNodes = (ExprNode[])CollectionUtil.arrayExpandAddSingle(this.childNodes, childNode);
    }

    @Override
    public final void addChildNodes(Collection<ExprNode> childNodeColl) {
        this.childNodes = (ExprNode[])CollectionUtil.arrayExpandAddElements((Object)this.childNodes, childNodeColl);
    }

    @Override
    public final ExprNode[] getChildNodes() {
        return this.childNodes;
    }

    @Override
    public void replaceUnlistedChildNode(ExprNode nodeToReplace, ExprNode newNode) {
    }

    public void addChildNodeToFront(ExprNode childNode) {
        this.childNodes = (ExprNode[])CollectionUtil.arrayExpandAddElements((Object)new ExprNode[]{childNode}, this.childNodes);
    }

    @Override
    public void setChildNodes(ExprNode ... nodes) {
        this.childNodes = nodes;
    }

    @Override
    public void setChildNode(int index, ExprNode newNode) {
        this.childNodes[index] = newNode;
    }
}

