/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.epl.agg.service.AggregationMethodFactory;
import com.espertech.esper.epl.expression.ExprAggregateNode;
import com.espertech.esper.epl.expression.ExprAggregateNodeBase;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNthAggNodeFactory;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;

public class ExprNthAggNode
extends ExprAggregateNodeBase {
    private static final long serialVersionUID = -843689785630260527L;

    public ExprNthAggNode(boolean distinct) {
        super(distinct);
    }

    @Override
    public AggregationMethodFactory validateAggregationChild(ExprValidationContext validationContext) throws ExprValidationException {
        String message = "The nth aggregation function requires two parameters, an expression returning aggregation values and a numeric index constant";
        if (this.getChildNodes().length != 2) {
            throw new ExprValidationException(message);
        }
        ExprNode first = this.getChildNodes()[0];
        ExprNode second = this.getChildNodes()[1];
        if (!second.isConstantResult()) {
            throw new ExprValidationException(message);
        }
        Number num = (Number)second.getExprEvaluator().evaluate(null, true, validationContext.getExprEvaluatorContext());
        int size = num.intValue();
        return new ExprNthAggNodeFactory(first.getExprEvaluator().getType(), size, this.isDistinct);
    }

    @Override
    protected String getAggregationFunctionName() {
        return "nth";
    }

    @Override
    public final boolean equalsNodeAggregate(ExprAggregateNode node) {
        return node instanceof ExprNthAggNode;
    }
}

