/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeBase;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.schedule.TimeProvider;
import com.espertech.esper.type.CronOperatorEnum;
import com.espertech.esper.type.CronParameter;
import com.espertech.esper.util.JavaClassHelper;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExprNumberSetCronParam
extends ExprNodeBase
implements ExprEvaluator {
    private static final Log log = LogFactory.getLog(ExprNumberSetCronParam.class);
    private final CronOperatorEnum cronOperator;
    private transient TimeProvider timeProvider;
    private transient ExprEvaluator evaluator;
    private static final long serialVersionUID = -1315999998249935318L;

    public ExprNumberSetCronParam(CronOperatorEnum cronOperator) {
        this.cronOperator = cronOperator;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    public CronOperatorEnum getCronOperator() {
        return this.cronOperator;
    }

    @Override
    public String toExpressionString() {
        if (this.getChildNodes().length == 0) {
            return this.cronOperator.getSyntax();
        }
        return this.getChildNodes()[0].toExpressionString() + " " + this.cronOperator.getSyntax();
    }

    @Override
    public boolean isConstantResult() {
        if (this.getChildNodes().length == 0) {
            return true;
        }
        return this.getChildNodes()[0].isConstantResult();
    }

    @Override
    public Map<String, Object> getEventType() {
        return null;
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprNumberSetCronParam)) {
            return false;
        }
        ExprNumberSetCronParam other = (ExprNumberSetCronParam)node;
        return other.cronOperator.equals((Object)this.cronOperator);
    }

    @Override
    public void validate(ExprValidationContext validationContext) throws ExprValidationException {
        this.timeProvider = validationContext.getTimeProvider();
        if (this.getChildNodes().length == 0) {
            return;
        }
        this.evaluator = this.getChildNodes()[0].getExprEvaluator();
        Class type = this.evaluator.getType();
        if (!JavaClassHelper.isNumericNonFP(type)) {
            throw new ExprValidationException("Frequency operator requires an integer-type parameter");
        }
    }

    @Override
    public Class getType() {
        return CronParameter.class;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (this.timeProvider == null) {
            throw new EPException("Expression node has not been validated");
        }
        if (this.getChildNodes().length == 0) {
            return new CronParameter(this.cronOperator, null, this.timeProvider.getTime());
        }
        Object value = this.evaluator.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (value == null) {
            log.warn((Object)"Null value returned for cron parameter");
            return new CronParameter(this.cronOperator, null, this.timeProvider.getTime());
        }
        int intValue = ((Number)value).intValue();
        return new CronParameter(this.cronOperator, intValue, this.timeProvider.getTime());
    }
}

